var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

import '../../../src/components/VCheckbox/VSimpleCheckbox.sass';
import ripple from '../../directives/ripple';
import Vue from 'vue';
import { VIcon } from '../VIcon';
import Colorable from '../../mixins/colorable';
import Themeable from '../../mixins/themeable';
import { wrapInArray } from '../../util/helpers';
export default Vue.extend({
    name: 'v-simple-checkbox',
    functional: true,
    directives: {
        ripple: ripple
    },
    props: _extends({}, Colorable.options.props, Themeable.options.props, {
        disabled: Boolean,
        ripple: {
            type: Boolean,
            default: true
        },
        value: Boolean,
        indeterminate: Boolean,
        indeterminateIcon: {
            type: String,
            default: '$vuetify.icons.checkboxIndeterminate'
        },
        onIcon: {
            type: String,
            default: '$vuetify.icons.checkboxOn'
        },
        offIcon: {
            type: String,
            default: '$vuetify.icons.checkboxOff'
        }
    }),
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data;

        var children = [];
        if (props.ripple && !props.disabled) {
            var _ripple = h('div', Colorable.options.methods.setTextColor(props.color, {
                staticClass: 'v-input--selection-controls__ripple',
                directives: [{
                    name: 'ripple',
                    value: { center: true }
                }]
            }));
            children.push(_ripple);
        }
        var icon = props.offIcon;
        if (props.indeterminate) icon = props.indeterminateIcon;else if (props.value) icon = props.onIcon;
        children.push(h(VIcon, Colorable.options.methods.setTextColor(props.value && props.color, {
            props: {
                disabled: props.disabled,
                dark: props.dark,
                light: props.light
            }
        }), icon));
        var classes = {
            'v-simple-checkbox': true,
            'v-simple-checkbox--disabled': props.disabled
        };
        return h('div', _extends({}, data, {
            class: classes,
            on: {
                click: function click() {
                    if (data.on && data.on.input && !props.disabled) {
                        wrapInArray(data.on.input).forEach(function (f) {
                            return f(!props.value);
                        });
                    }
                }
            }
        }), children);
    }
});
//# sourceMappingURL=VSimpleCheckbox.js.map