import Vue from 'vue';
import { getObjectValueByPath } from '../../util/helpers';
export default Vue.extend({
    name: 'v-row',
    functional: true,
    props: {
        headers: Array,
        item: Object,
        rtl: Boolean
    },
    render: function render(h, _ref) {
        var props = _ref.props,
            slots = _ref.slots,
            data = _ref.data;

        var computedSlots = slots();
        var columns = props.headers.map(function (header) {
            var classes = {
                'v-data-table__mobile-row': true
            };
            var children = [];
            var value = getObjectValueByPath(props.item, header.value);
            var slotName = header.value;
            var scopedSlot = data.scopedSlots && data.scopedSlots[slotName];
            var regularSlot = computedSlots[slotName];
            if (scopedSlot) {
                children.push(scopedSlot({ item: props.item, header: header, value: value }));
            } else if (regularSlot) {
                children.push(regularSlot);
            } else {
                children.push(value);
            }
            return h('td', {
                class: classes
            }, [h('div', { staticClass: 'v-data-table__mobile-row__wrapper' }, [header.value !== 'dataTableSelect' && h('div', { staticClass: 'v-data-table__mobile-row__header' }, [header.text]), h('div', { staticClass: 'v-data-table__mobile-row__cell' }, children)])]);
        });
        return h('tr', data, columns);
    }
});
//# sourceMappingURL=VMobileRow.js.map