var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import '../../../src/components/VProgressLinear/VProgressLinear.sass';
// Components
import { VFadeTransition, VSlideXTransition } from '../transitions';
// Mixins
import Colorable from '../../mixins/colorable';
import { factory as PositionableFactory } from '../../mixins/positionable';
import Proxyable from '../../mixins/proxyable';
import Themeable from '../../mixins/themeable';
// Utilities
import { convertToUnit, getSlot } from '../../util/helpers';
import mixins from '../../util/mixins';
var baseMixins = mixins(Colorable, PositionableFactory(['absolute', 'fixed', 'top', 'bottom']), Proxyable, Themeable);
/* @vue/component */
export default baseMixins.extend({
    name: 'v-progress-linear',
    props: {
        active: {
            type: Boolean,
            default: true
        },
        backgroundColor: {
            type: String,
            default: null
        },
        backgroundOpacity: {
            type: [Number, String],
            default: null
        },
        bufferValue: {
            type: [Number, String],
            default: 100
        },
        color: {
            type: String,
            default: 'primary'
        },
        height: {
            type: [Number, String],
            default: 4
        },
        indeterminate: Boolean,
        query: Boolean,
        rounded: Boolean,
        stream: Boolean,
        striped: Boolean,
        value: {
            type: [Number, String],
            default: 0
        }
    },
    data: function data() {
        return {
            internalLazyValue: this.value || 0
        };
    },

    computed: {
        __cachedBackground: function __cachedBackground() {
            return this.$createElement('div', this.setBackgroundColor(this.backgroundColor || this.color, {
                staticClass: 'v-progress-linear__background',
                style: this.backgroundStyle
            }));
        },
        __cachedBar: function __cachedBar() {
            return this.$createElement(this.computedTransition, [this.__cachedBarType]);
        },
        __cachedBarType: function __cachedBarType() {
            return this.indeterminate ? this.__cachedIndeterminate : this.__cachedDeterminate;
        },
        __cachedBuffer: function __cachedBuffer() {
            return this.$createElement('div', {
                staticClass: 'v-progress-linear__buffer',
                style: this.styles
            });
        },
        __cachedDeterminate: function __cachedDeterminate() {
            return this.$createElement('div', this.setBackgroundColor(this.color, {
                staticClass: 'v-progress-linear__determinate',
                style: {
                    width: convertToUnit(this.normalizedValue, '%')
                }
            }));
        },
        __cachedIndeterminate: function __cachedIndeterminate() {
            return this.$createElement('div', {
                staticClass: 'v-progress-linear__indeterminate',
                class: {
                    'v-progress-linear__indeterminate--active': this.active
                }
            }, [this.genProgressBar('long'), this.genProgressBar('short')]);
        },
        __cachedStream: function __cachedStream() {
            if (!this.stream) return null;
            return this.$createElement('div', this.setTextColor(this.color, {
                staticClass: 'v-progress-linear__stream',
                style: {
                    width: convertToUnit(100 - this.normalizedBuffer, '%')
                }
            }));
        },
        backgroundStyle: function backgroundStyle() {
            var backgroundOpacity = this.backgroundOpacity == null ? this.backgroundColor ? 1 : 0.3 : parseFloat(this.backgroundOpacity);
            return {
                opacity: backgroundOpacity,
                width: convertToUnit(this.normalizedBuffer, '%')
            };
        },
        classes: function classes() {
            return _extends({
                'v-progress-linear--absolute': this.absolute,
                'v-progress-linear--fixed': this.fixed,
                'v-progress-linear--query': this.query,
                'v-progress-linear--reactive': this.reactive,
                'v-progress-linear--rounded': this.rounded,
                'v-progress-linear--striped': this.striped
            }, this.themeClasses);
        },
        computedTransition: function computedTransition() {
            return this.indeterminate ? VFadeTransition : VSlideXTransition;
        },
        normalizedBuffer: function normalizedBuffer() {
            return this.normalize(this.bufferValue);
        },
        normalizedValue: function normalizedValue() {
            return this.normalize(this.internalLazyValue);
        },
        reactive: function reactive() {
            return Boolean(this.$listeners.change);
        },
        styles: function styles() {
            var styles = {};
            if (!this.active) {
                styles.height = 0;
            }
            if (!this.indeterminate && parseFloat(this.normalizedBuffer) !== 100) {
                styles.width = convertToUnit(this.normalizedBuffer, '%');
            }
            return styles;
        }
    },
    methods: {
        genContent: function genContent() {
            var slot = getSlot(this, 'default', { value: this.internalLazyValue });
            if (!slot) return null;
            return this.$createElement('div', {
                staticClass: 'v-progress-linear__content'
            }, slot);
        },
        genListeners: function genListeners() {
            var listeners = this.$listeners;
            if (this.reactive) {
                listeners.click = this.onClick;
            }
            return listeners;
        },
        genProgressBar: function genProgressBar(name) {
            return this.$createElement('div', this.setBackgroundColor(this.color, {
                staticClass: 'v-progress-linear__indeterminate',
                class: _defineProperty({}, name, true)
            }));
        },
        onClick: function onClick(e) {
            if (!this.reactive) return;

            var _$el$getBoundingClien = this.$el.getBoundingClientRect(),
                width = _$el$getBoundingClien.width;

            this.internalValue = e.offsetX / width * 100;
        },
        normalize: function normalize(value) {
            if (value < 0) return 0;
            if (value > 100) return 100;
            return parseFloat(value);
        }
    },
    render: function render(h) {
        var data = {
            staticClass: 'v-progress-linear',
            attrs: {
                'role': 'progressbar',
                'aria-valuemin': 0,
                'aria-valuemax': this.normalizedBuffer,
                'aria-valuenow': this.indeterminate ? undefined : this.normalizedValue
            },
            class: this.classes,
            style: {
                bottom: this.bottom ? 0 : undefined,
                height: this.active ? convertToUnit(this.height) : 0,
                top: this.top ? 0 : undefined
            },
            on: this.genListeners()
        };
        return h('div', data, [this.__cachedStream, this.__cachedBackground, this.__cachedBuffer, this.__cachedBar, this.genContent()]);
    }
});
//# sourceMappingURL=VProgressLinear.js.map