function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Mixins
import { inject as RegistrableInject } from '../registrable';
export function factory(namespace, child, parent) {
    // TODO: ts 3.4 broke directly returning this
    var R = RegistrableInject(namespace, child, parent).extend({
        name: 'groupable',
        props: {
            activeClass: {
                type: String,
                default: function _default() {
                    if (!this[namespace]) return undefined;
                    return this[namespace].activeClass;
                }
            },
            disabled: Boolean
        },
        data: function data() {
            return {
                isActive: false
            };
        },

        computed: {
            groupClasses: function groupClasses() {
                if (!this.activeClass) return {};
                return _defineProperty({}, this.activeClass, this.isActive);
            }
        },
        created: function created() {
            this[namespace] && this[namespace].register(this);
        },
        beforeDestroy: function beforeDestroy() {
            this[namespace] && this[namespace].unregister(this);
        },

        methods: {
            toggle: function toggle() {
                this.$emit('change');
            }
        }
    });
    return R;
}
/* eslint-disable-next-line no-redeclare */
var Groupable = factory('itemGroup');
export default Groupable;
//# sourceMappingURL=index.js.map