'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components

// Mixins

// Directives

// Utilities


require('../../../src/components/VChip/VChip.sass');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _transitions = require('../transitions');

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _groupable = require('../../mixins/groupable');

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _toggleable = require('../../mixins/toggleable');

var _routable = require('../../mixins/routable');

var _routable2 = _interopRequireDefault(_routable);

var _sizeable = require('../../mixins/sizeable');

var _sizeable2 = _interopRequireDefault(_sizeable);

var _ripple = require('../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_colorable2.default, _sizeable2.default, _routable2.default, _themeable2.default, (0, _groupable.factory)('chipGroup'), (0, _toggleable.factory)('inputValue')).extend({
    name: 'v-chip',
    directives: { Ripple: _ripple2.default },
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.chipGroup) return '';
                return this.chipGroup.activeClass;
            }
        },
        close: Boolean,
        closeIcon: {
            type: String,
            default: '$vuetify.icons.delete'
        },
        disabled: Boolean,
        draggable: Boolean,
        filter: Boolean,
        filterIcon: {
            type: String,
            default: '$vuetify.icons.complete'
        },
        label: Boolean,
        link: Boolean,
        outlined: Boolean,
        pill: Boolean,
        tag: {
            type: String,
            default: 'span'
        },
        textColor: String,
        value: null
    },
    data: function data() {
        return {
            proxyClass: 'v-chip--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-chip': true
            }, _routable2.default.options.computed.classes.call(this), {
                'v-chip--clickable': this.isClickable,
                'v-chip--disabled': this.disabled,
                'v-chip--draggable': this.draggable,
                'v-chip--label': this.label,
                'v-chip--link': this.isLink,
                'v-chip--no-color': !this.color,
                'v-chip--outlined': this.outlined,
                'v-chip--pill': this.pill,
                'v-chip--removable': this.hasClose
            }, this.themeClasses, this.sizeableClasses, this.groupClasses);
        },
        hasClose: function hasClose() {
            return Boolean(this.close);
        },
        isClickable: function isClickable() {
            return Boolean(_routable2.default.options.computed.isClickable.call(this) || this.chipGroup);
        }
    },
    created: function created() {
        var _this = this;

        var breakingProps = [['outline', 'outlined'], ['selected', 'value']];
        /* istanbul ignore next */
        breakingProps.forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                original = _ref2[0],
                replacement = _ref2[1];

            if (_this.$attrs.hasOwnProperty(original)) (0, _console.breaking)(original, replacement, _this);
        });
    },

    methods: {
        click: function click(e) {
            this.$emit('click', e);
            this.chipGroup && this.toggle();
        },
        genFilter: function genFilter() {
            var children = [];
            if (this.isActive) {
                children.push(this.$createElement(_VIcon2.default, {
                    staticClass: 'v-chip__filter',
                    props: { left: true }
                }, this.filterIcon));
            }
            return this.$createElement(_transitions.VExpandXTransition, children);
        },
        genClose: function genClose() {
            var _this2 = this;

            return this.$createElement(_VIcon2.default, {
                staticClass: 'v-chip__close',
                props: {
                    right: true
                },
                on: {
                    click: function click(e) {
                        e.stopPropagation();
                        _this2.$emit('click:close');
                    }
                }
            }, this.closeIcon);
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-chip__content'
            }, [this.filter && this.genFilter(), this.$slots.default, this.hasClose && this.genClose()]);
        }
    },
    render: function render(h) {
        var children = [this.genContent()];

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.attrs = _extends({}, data.attrs, {
            draggable: this.draggable ? 'true' : undefined,
            tabindex: this.chipGroup && !this.disabled ? 0 : data.attrs.tabindex
        });
        data = this.setBackgroundColor(this.color, data);
        var color = this.textColor || this.outlined && this.color;
        return h(tag, this.setTextColor(color, data), children);
    }
});
//# sourceMappingURL=VChip.js.map