'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

require('../../../src/components/VDataTable/VDataTableHeader.sass');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

var _dedupeModelListeners = require('../../util/dedupeModelListeners');

var _dedupeModelListeners2 = _interopRequireDefault(_dedupeModelListeners);

var _rebuildFunctionalSlots = require('../../util/rebuildFunctionalSlots');

var _rebuildFunctionalSlots2 = _interopRequireDefault(_rebuildFunctionalSlots);

var _VDataTableHeaderMobile = require('./VDataTableHeaderMobile');

var _VDataTableHeaderMobile2 = _interopRequireDefault(_VDataTableHeaderMobile);

var _VDataTableHeaderDesktop = require('./VDataTableHeaderDesktop');

var _VDataTableHeaderDesktop2 = _interopRequireDefault(_VDataTableHeaderDesktop);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _vue2.default.extend({
    name: 'v-data-table-header',
    functional: true,
    props: {
        mobile: Boolean
    },
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            slots = _ref.slots;

        (0, _dedupeModelListeners2.default)(data);
        var children = (0, _rebuildFunctionalSlots2.default)(slots(), h);
        if (props.mobile) {
            return h(_VDataTableHeaderMobile2.default, data, children);
        } else {
            return h(_VDataTableHeaderDesktop2.default, data, children);
        }
    }
});
//# sourceMappingURL=VDataTableHeader.js.map