'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Components

// Mixins

// Directives

// Utilities

// Types


require('../../../src/components/VTextField/VTextField.sass');

var _VInput = require('../VInput');

var _VInput2 = _interopRequireDefault(_VInput);

var _VCounter = require('../VCounter');

var _VCounter2 = _interopRequireDefault(_VCounter);

var _VLabel = require('../VLabel');

var _VLabel2 = _interopRequireDefault(_VLabel);

var _loadable = require('../../mixins/loadable');

var _loadable2 = _interopRequireDefault(_loadable);

var _ripple = require('../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _helpers = require('../../util/helpers');

var _console = require('../../util/console');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)(_VInput2.default, _loadable2.default);
var dirtyTypes = ['color', 'file', 'time', 'date', 'datetime-local', 'week', 'month'];
/* @vue/component */
exports.default = baseMixins.extend().extend({
    name: 'v-text-field',
    directives: { Ripple: _ripple2.default },
    inheritAttrs: false,
    props: {
        appendOuterIcon: String,
        autofocus: Boolean,
        clearable: Boolean,
        clearIcon: {
            type: String,
            default: '$vuetify.icons.clear'
        },
        color: {
            type: String,
            default: 'primary'
        },
        counter: [Boolean, Number, String],
        filled: Boolean,
        flat: Boolean,
        fullWidth: Boolean,
        label: String,
        outlined: Boolean,
        placeholder: String,
        prefix: String,
        prependInnerIcon: String,
        reverse: Boolean,
        rounded: Boolean,
        singleLine: Boolean,
        shaped: Boolean,
        solo: Boolean,
        soloInverted: Boolean,
        suffix: String,
        type: {
            type: String,
            default: 'text'
        }
    },
    data: function data() {
        return {
            badInput: false,
            labelWidth: 0,
            prefixWidth: 0,
            prependWidth: 0,
            initialValue: null,
            isBooted: false,
            isClearing: false
        };
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VInput2.default.options.computed.classes.call(this), {
                'v-text-field': true,
                'v-text-field--full-width': this.fullWidth,
                'v-text-field--prefix': this.prefix,
                'v-text-field--single-line': this.isSingle,
                'v-text-field--solo': this.isSolo,
                'v-text-field--solo-inverted': this.soloInverted,
                'v-text-field--solo-flat': this.flat,
                'v-text-field--filled': this.filled,
                'v-text-field--is-booted': this.isBooted,
                'v-text-field--enclosed': this.isEnclosed,
                'v-text-field--reverse': this.reverse,
                'v-text-field--outlined': this.outlined,
                'v-text-field--placeholder': this.placeholder,
                'v-text-field--rounded': this.rounded,
                'v-text-field--shaped': this.shaped
            });
        },
        counterValue: function counterValue() {
            return (this.internalValue || '').toString().length;
        },

        internalValue: {
            get: function get() {
                return this.lazyValue;
            },
            set: function set(val) {
                this.lazyValue = val;
                this.$emit('input', this.lazyValue);
            }
        },
        isDirty: function isDirty() {
            return this.lazyValue != null && this.lazyValue.toString().length > 0 || this.badInput;
        },
        isEnclosed: function isEnclosed() {
            return this.filled || this.isSolo || this.outlined || this.fullWidth;
        },
        isLabelActive: function isLabelActive() {
            return this.isDirty || dirtyTypes.includes(this.type);
        },
        isSingle: function isSingle() {
            return this.isSolo || this.singleLine || this.fullWidth;
        },
        isSolo: function isSolo() {
            return this.solo || this.soloInverted;
        },
        labelPosition: function labelPosition() {
            var offset = this.prefix && !this.labelValue ? this.prefixWidth : 0;
            if (this.labelValue && this.prependWidth) offset -= this.prependWidth;
            return this.$vuetify.rtl === this.reverse ? {
                left: offset,
                right: 'auto'
            } : {
                left: 'auto',
                right: offset
            };
        },
        showLabel: function showLabel() {
            return this.hasLabel && (!this.isSingle || !this.isLabelActive && !this.placeholder);
        },
        labelValue: function labelValue() {
            return !this.isSingle && Boolean(this.isFocused || this.isLabelActive || this.placeholder);
        }
    },
    watch: {
        labelValue: 'setLabelWidth',
        outlined: 'setLabelWidth',
        isFocused: function isFocused(val) {
            // Sets validationState from validatable
            this.hasColor = val;
            if (val) {
                this.initialValue = this.lazyValue;
            } else if (this.initialValue !== this.lazyValue) {
                this.$emit('change', this.lazyValue);
            }
        },
        value: function value(val) {
            this.lazyValue = val;
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.$attrs.hasOwnProperty('box')) {
            (0, _console.breaking)('box', 'filled', this);
        }
        /* istanbul ignore next */
        if (this.$attrs.hasOwnProperty('browser-autocomplete')) {
            (0, _console.breaking)('browser-autocomplete', 'autocomplete', this);
        }
        /* istanbul ignore if */
        if (this.shaped && !(this.filled || this.outlined || this.isSolo)) {
            (0, _console.consoleWarn)('shaped should be used with either filled or outlined', this);
        }
    },
    mounted: function mounted() {
        var _this = this;

        this.autofocus && this.onFocus();
        this.setLabelWidth();
        this.setPrefixWidth();
        this.setPrependWidth();
        requestAnimationFrame(function () {
            return _this.isBooted = true;
        });
    },

    methods: {
        /** @public */
        focus: function focus() {
            this.onFocus();
        },

        /** @public */
        blur: function blur(e) {
            var _this2 = this;

            // https://github.com/vuetifyjs/vuetify/issues/5913
            // Safari tab order gets broken if called synchronous
            window.requestAnimationFrame(function () {
                _this2.$refs.input && _this2.$refs.input.blur();
            });
            this.onBlur(e);
        },
        clearableCallback: function clearableCallback() {
            var _this3 = this;

            this.internalValue = null;
            this.$nextTick(function () {
                return _this3.$refs.input && _this3.$refs.input.focus();
            });
        },
        genAppendSlot: function genAppendSlot() {
            var slot = [];
            if (this.$slots['append-outer']) {
                slot.push(this.$slots['append-outer']);
            } else if (this.appendOuterIcon) {
                slot.push(this.genIcon('appendOuter'));
            }
            return this.genSlot('append', 'outer', slot);
        },
        genPrependInnerSlot: function genPrependInnerSlot() {
            var slot = [];
            if (this.$slots['prepend-inner']) {
                slot.push(this.$slots['prepend-inner']);
            } else if (this.prependInnerIcon) {
                slot.push(this.genIcon('prependInner'));
            }
            return this.genSlot('prepend', 'inner', slot);
        },
        genIconSlot: function genIconSlot() {
            var slot = [];
            if (this.$slots['append']) {
                slot.push(this.$slots['append']);
            } else if (this.appendIcon) {
                slot.push(this.genIcon('append'));
            }
            return this.genSlot('append', 'inner', slot);
        },
        genInputSlot: function genInputSlot() {
            var input = _VInput2.default.options.methods.genInputSlot.call(this);
            var prepend = this.genPrependInnerSlot();
            if (prepend) {
                input.children = input.children || [];
                input.children.unshift(prepend);
            }
            return input;
        },
        genClearIcon: function genClearIcon() {
            if (!this.clearable) return null;
            var icon = this.isDirty ? 'clear' : '';
            return this.genSlot('append', 'inner', [this.genIcon(icon, this.clearableCallback)]);
        },
        genCounter: function genCounter() {
            if (this.counter === false || this.counter == null) return null;
            var max = this.counter === true ? this.$attrs.maxlength : this.counter;
            return this.$createElement(_VCounter2.default, {
                props: {
                    dark: this.dark,
                    light: this.light,
                    max: max,
                    value: this.counterValue
                }
            });
        },
        genDefaultSlot: function genDefaultSlot() {
            return [this.genFieldset(), this.genTextFieldSlot(), this.genClearIcon(), this.genIconSlot(), this.genProgress()];
        },
        genFieldset: function genFieldset() {
            if (!this.outlined) return null;
            return this.$createElement('fieldset', {
                attrs: {
                    'aria-hidden': true
                }
            }, [this.genLegend()]);
        },
        genLabel: function genLabel() {
            if (!this.showLabel) return null;
            var data = {
                props: {
                    absolute: true,
                    color: this.validationState,
                    dark: this.dark,
                    disabled: this.disabled,
                    focused: !this.isSingle && (this.isFocused || !!this.validationState),
                    for: this.id,
                    left: this.labelPosition.left,
                    light: this.light,
                    right: this.labelPosition.right,
                    value: this.labelValue
                }
            };
            return this.$createElement(_VLabel2.default, data, this.$slots.label || this.label);
        },
        genLegend: function genLegend() {
            var width = !this.singleLine && (this.labelValue || this.isDirty) ? this.labelWidth : 0;
            var span = this.$createElement('span', {
                domProps: { innerHTML: '&#8203;' }
            });
            return this.$createElement('legend', {
                style: {
                    width: (0, _helpers.convertToUnit)(width)
                }
            }, [span]);
        },
        genInput: function genInput() {
            var listeners = Object.assign({}, this.$listeners);
            delete listeners['change']; // Change should not be bound externally
            return this.$createElement('input', {
                style: {},
                domProps: {
                    value: this.lazyValue
                },
                attrs: _extends({
                    'aria-label': !this.id && this.label
                }, this.$attrs, {
                    autofocus: this.autofocus,
                    disabled: this.disabled,
                    id: this.id,
                    placeholder: this.placeholder,
                    readonly: this.readonly,
                    type: this.type
                }),
                on: Object.assign(listeners, {
                    blur: this.onBlur,
                    input: this.onInput,
                    focus: this.onFocus,
                    keydown: this.onKeyDown
                }),
                ref: 'input'
            });
        },
        genMessages: function genMessages() {
            if (this.hideDetails) return null;
            return this.$createElement('div', {
                staticClass: 'v-text-field__details'
            }, [_VInput2.default.options.methods.genMessages.call(this), this.genCounter()]);
        },
        genTextFieldSlot: function genTextFieldSlot() {
            return this.$createElement('div', {
                staticClass: 'v-text-field__slot'
            }, [this.genLabel(), this.prefix ? this.genAffix('prefix') : null, this.genInput(), this.suffix ? this.genAffix('suffix') : null]);
        },
        genAffix: function genAffix(type) {
            return this.$createElement('div', {
                'class': 'v-text-field__' + type,
                ref: type
            }, this[type]);
        },
        onBlur: function onBlur(e) {
            this.isFocused = false;
            e && this.$emit('blur', e);
        },
        onClick: function onClick() {
            if (this.isFocused || this.disabled) return;
            this.$refs.input.focus();
        },
        onFocus: function onFocus(e) {
            if (!this.$refs.input) return;
            if (document.activeElement !== this.$refs.input) {
                return this.$refs.input.focus();
            }
            if (!this.isFocused) {
                this.isFocused = true;
                e && this.$emit('focus', e);
            }
        },
        onInput: function onInput(e) {
            var target = e.target;
            this.internalValue = target.value;
            this.badInput = target.validity && target.validity.badInput;
        },
        onKeyDown: function onKeyDown(e) {
            if (e.keyCode === _helpers.keyCodes.enter) this.$emit('change', this.internalValue);
            this.$emit('keydown', e);
        },
        onMouseDown: function onMouseDown(e) {
            // Prevent input from being blurred
            if (e.target !== this.$refs.input) {
                e.preventDefault();
                e.stopPropagation();
            }
            _VInput2.default.options.methods.onMouseDown.call(this, e);
        },
        onMouseUp: function onMouseUp(e) {
            if (this.hasMouseDown) this.focus();
            _VInput2.default.options.methods.onMouseUp.call(this, e);
        },
        setLabelWidth: function setLabelWidth() {
            if (!this.outlined || !this.$refs.label) return;
            this.labelWidth = this.$refs.label.offsetWidth * 0.75 + 6;
        },
        setPrefixWidth: function setPrefixWidth() {
            if (!this.$refs.prefix) return;
            this.prefixWidth = this.$refs.prefix.offsetWidth;
        },
        setPrependWidth: function setPrependWidth() {
            if (!this.outlined || !this.$refs['prepend-inner']) return;
            this.prependWidth = this.$refs['prepend-inner'].offsetWidth;
        }
    }
});
//# sourceMappingURL=VTextField.js.map