'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.parse = parse;
exports.genStyles = genStyles;
exports.genVariations = genVariations;

var _colorUtils = require('../../util/colorUtils');

var _transformSRGB = require('../../util/color/transformSRGB');

var sRGB = _interopRequireWildcard(_transformSRGB);

var _transformCIELAB = require('../../util/color/transformCIELAB');

var LAB = _interopRequireWildcard(_transformCIELAB);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function parse(theme) {
    var isItem = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var anchor = theme.anchor,
        variant = _objectWithoutProperties(theme, ['anchor']);

    var colors = Object.keys(variant);
    var parsedTheme = {};
    for (var i = 0; i < colors.length; ++i) {
        var name = colors[i];
        var value = theme[name];
        if (value == null) continue;
        if (isItem) {
            /* istanbul ignore else */
            if (name === 'base' || name.startsWith('lighten') || name.startsWith('darken')) {
                parsedTheme[name] = (0, _colorUtils.colorToHex)(value);
            }
        } else if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
            parsedTheme[name] = parse(value, true);
        } else {
            parsedTheme[name] = genVariations(name, (0, _colorUtils.colorToInt)(value));
        }
    }
    if (!isItem) {
        parsedTheme.anchor = anchor || parsedTheme.base || parsedTheme.primary.base;
    }
    return parsedTheme;
}
/**
 * Generate the CSS for a base color (.primary)
 */
var genBaseColor = function genBaseColor(name, value) {
    return '\n.' + name + ' {\n  background-color: ' + value + ' !important;\n  border-color: ' + value + ' !important;\n}\n.' + name + '--text {\n  color: ' + value + ' !important;\n  caret-color: ' + value + ' !important;\n}';
};
/**
 * Generate the CSS for a variant color (.primary.darken-2)
 */
var genVariantColor = function genVariantColor(name, variant, value) {
    var _variant$split = variant.split(/(\d)/, 2),
        _variant$split2 = _slicedToArray(_variant$split, 2),
        type = _variant$split2[0],
        n = _variant$split2[1];

    return '\n.' + name + '.' + type + '-' + n + ' {\n  background-color: ' + value + ' !important;\n  border-color: ' + value + ' !important;\n}\n.' + name + '--text.text--' + type + '-' + n + ' {\n  color: ' + value + ' !important;\n  caret-color: ' + value + ' !important;\n}';
};
var genColorVariableName = function genColorVariableName(name) {
    var variant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'base';
    return '--v-' + name + '-' + variant;
};
var genColorVariable = function genColorVariable(name) {
    var variant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'base';
    return 'var(' + genColorVariableName(name, variant) + ')';
};
function genStyles(theme) {
    var cssVar = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var anchor = theme.anchor,
        variant = _objectWithoutProperties(theme, ['anchor']);

    var colors = Object.keys(variant);
    if (!colors.length) return '';
    var variablesCss = '';
    var css = '';
    var aColor = cssVar ? genColorVariable('anchor') : anchor;
    css += 'a { color: ' + aColor + '; }';
    cssVar && (variablesCss += '  ' + genColorVariableName('anchor') + ': ' + anchor + ';\n');
    for (var i = 0; i < colors.length; ++i) {
        var name = colors[i];
        var value = theme[name];
        css += genBaseColor(name, cssVar ? genColorVariable(name) : value.base);
        cssVar && (variablesCss += '  ' + genColorVariableName(name) + ': ' + value.base + ';\n');
        var variants = Object.keys(value);
        for (var _i = 0; _i < variants.length; ++_i) {
            var _variant = variants[_i];
            var variantValue = value[_variant];
            if (_variant === 'base') continue;
            css += genVariantColor(name, _variant, cssVar ? genColorVariable(name, _variant) : variantValue);
            cssVar && (variablesCss += '  ' + genColorVariableName(name, _variant) + ': ' + variantValue + ';\n');
        }
    }
    if (cssVar) {
        variablesCss = ':root {\n' + variablesCss + '}\n\n';
    }
    return variablesCss + css;
}
function genVariations(name, value) {
    var values = {
        base: (0, _colorUtils.intToHex)(value)
    };
    for (var i = 5; i > 0; --i) {
        values['lighten' + i] = (0, _colorUtils.intToHex)(lighten(value, i));
    }
    for (var _i2 = 1; _i2 <= 4; ++_i2) {
        values['darken' + _i2] = (0, _colorUtils.intToHex)(darken(value, _i2));
    }
    return values;
}
function lighten(value, amount) {
    var lab = LAB.fromXYZ(sRGB.toXYZ(value));
    lab[0] = lab[0] + amount * 10;
    return sRGB.fromXYZ(LAB.toXYZ(lab));
}
function darken(value, amount) {
    var lab = LAB.fromXYZ(sRGB.toXYZ(value));
    lab[0] = lab[0] - amount * 10;
    return sRGB.fromXYZ(LAB.toXYZ(lab));
}
//# sourceMappingURL=utils.js.map