'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.camelize = exports.keyCodes = exports.passiveSupported = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.createSimpleFunctional = createSimpleFunctional;
exports.createSimpleTransition = createSimpleTransition;
exports.createJavaScriptTransition = createJavaScriptTransition;
exports.directiveConfig = directiveConfig;
exports.addOnceEventListener = addOnceEventListener;
exports.addPassiveEventListener = addPassiveEventListener;
exports.getNestedValue = getNestedValue;
exports.deepEqual = deepEqual;
exports.getObjectValueByPath = getObjectValueByPath;
exports.getPropertyFromItem = getPropertyFromItem;
exports.createRange = createRange;
exports.getZIndex = getZIndex;
exports.escapeHTML = escapeHTML;
exports.filterObjectOnKeys = filterObjectOnKeys;
exports.convertToUnit = convertToUnit;
exports.kebabCase = kebabCase;
exports.isObject = isObject;
exports.remapInternalIcon = remapInternalIcon;
exports.keys = keys;
exports.arrayDiff = arrayDiff;
exports.upperFirst = upperFirst;
exports.groupByProperty = groupByProperty;
exports.wrapInArray = wrapInArray;
exports.sortItems = sortItems;
exports.defaultFilter = defaultFilter;
exports.searchItems = searchItems;
exports.getSlotType = getSlotType;
exports.debounce = debounce;
exports.getPrefixedScopedSlots = getPrefixedScopedSlots;
exports.getSlot = getSlot;
exports.clamp = clamp;
exports.padEnd = padEnd;
exports.chunk = chunk;

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createSimpleFunctional(c) {
    var el = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'div';
    var name = arguments[2];

    return _vue2.default.extend({
        name: name || c.replace(/__/g, '-'),
        functional: true,
        render: function render(h, _ref) {
            var data = _ref.data,
                children = _ref.children;

            data.staticClass = (c + ' ' + (data.staticClass || '')).trim();
            return h(el, data, children);
        }
    });
}
function mergeTransitions(transitions, array) {
    if (Array.isArray(transitions)) return transitions.concat(array);
    if (transitions) array.push(transitions);
    return array;
}
function createSimpleTransition(name) {
    var origin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top center 0';
    var mode = arguments[2];

    return {
        name: name,
        functional: true,
        props: {
            group: {
                type: Boolean,
                default: false
            },
            hideOnLeave: {
                type: Boolean,
                default: false
            },
            leaveAbsolute: {
                type: Boolean,
                default: false
            },
            mode: {
                type: String,
                default: mode
            },
            origin: {
                type: String,
                default: origin
            }
        },
        render: function render(h, context) {
            var tag = 'transition' + (context.props.group ? '-group' : '');
            context.data = context.data || {};
            context.data.props = {
                name: name,
                mode: context.props.mode
            };
            context.data.on = context.data.on || {};
            if (!Object.isExtensible(context.data.on)) {
                context.data.on = _extends({}, context.data.on);
            }
            var ourBeforeEnter = [];
            var ourLeave = [];
            var absolute = function absolute(el) {
                return el.style.position = 'absolute';
            };
            ourBeforeEnter.push(function (el) {
                el.style.transformOrigin = context.props.origin;
                el.style.webkitTransformOrigin = context.props.origin;
            });
            if (context.props.leaveAbsolute) ourLeave.push(absolute);
            if (context.props.hideOnLeave) {
                ourLeave.push(function (el) {
                    return el.style.display = 'none';
                });
            }
            var _context$data$on = context.data.on,
                beforeEnter = _context$data$on.beforeEnter,
                leave = _context$data$on.leave;
            // Type says Function | Function[] but
            // will only work if provided a function

            context.data.on.beforeEnter = function () {
                return mergeTransitions(beforeEnter, ourBeforeEnter);
            };
            context.data.on.leave = mergeTransitions(leave, ourLeave);
            return h(tag, context.data, context.children);
        }
    };
}
function createJavaScriptTransition(name, functions) {
    var mode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'in-out';

    return {
        name: name,
        functional: true,
        props: {
            mode: {
                type: String,
                default: mode
            }
        },
        render: function render(h, context) {
            var data = {
                props: _extends({}, context.props, {
                    name: name
                }),
                on: functions
            };
            return h('transition', data, context.children);
        }
    };
}
function directiveConfig(binding) {
    var defaults = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return _extends({}, defaults, binding.modifiers, {
        value: binding.arg
    }, binding.value || {});
}
function addOnceEventListener(el, event, cb) {
    var once = function once() {
        cb();
        el.removeEventListener(event, once, false);
    };
    el.addEventListener(event, once, false);
}
var passiveSupported = false;
try {
    if (typeof window !== 'undefined') {
        var testListenerOpts = Object.defineProperty({}, 'passive', {
            get: function get() {
                exports.passiveSupported = passiveSupported = true;
            }
        });
        window.addEventListener('testListener', testListenerOpts, testListenerOpts);
        window.removeEventListener('testListener', testListenerOpts, testListenerOpts);
    }
} catch (e) {
    console.warn(e);
}
exports.passiveSupported = passiveSupported;
function addPassiveEventListener(el, event, cb, options) {
    el.addEventListener(event, cb, passiveSupported ? options : false);
}
function getNestedValue(obj, path, fallback) {
    var last = path.length - 1;
    if (last < 0) return obj === undefined ? fallback : obj;
    for (var i = 0; i < last; i++) {
        if (obj == null) {
            return fallback;
        }
        obj = obj[path[i]];
    }
    if (obj == null) return fallback;
    return obj[path[last]] === undefined ? fallback : obj[path[last]];
}
function deepEqual(a, b) {
    if (a === b) return true;
    if (a instanceof Date && b instanceof Date) {
        // If the values are Date, they were convert to timestamp with getTime and compare it
        if (a.getTime() !== b.getTime()) return false;
    }
    if (a !== Object(a) || b !== Object(b)) {
        // If the values aren't objects, they were already checked for equality
        return false;
    }
    var props = Object.keys(a);
    if (props.length !== Object.keys(b).length) {
        // Different number of props, don't bother to check
        return false;
    }
    return props.every(function (p) {
        return deepEqual(a[p], b[p]);
    });
}
function getObjectValueByPath(obj, path, fallback) {
    // credit: http://stackoverflow.com/questions/6491463/accessing-nested-javascript-objects-with-string-key#comment55278413_6491621
    if (obj == null || !path || typeof path !== 'string') return fallback;
    if (obj[path] !== undefined) return obj[path];
    path = path.replace(/\[(\w+)\]/g, '.$1'); // convert indexes to properties
    path = path.replace(/^\./, ''); // strip a leading dot
    return getNestedValue(obj, path.split('.'), fallback);
}
function getPropertyFromItem(item, property, fallback) {
    if (property == null) return item === undefined ? fallback : item;
    if (item !== Object(item)) return fallback === undefined ? item : fallback;
    if (typeof property === 'string') return getObjectValueByPath(item, property, fallback);
    if (Array.isArray(property)) return getNestedValue(item, property, fallback);
    if (typeof property !== 'function') return fallback;
    var value = property(item, fallback);
    return typeof value === 'undefined' ? fallback : value;
}
function createRange(length) {
    return Array.from({ length: length }, function (v, k) {
        return k;
    });
}
function getZIndex(el) {
    if (!el || el.nodeType !== Node.ELEMENT_NODE) return 0;
    var index = +window.getComputedStyle(el).getPropertyValue('z-index');
    if (!index) return getZIndex(el.parentNode);
    return index;
}
var tagsToReplace = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;'
};
function escapeHTML(str) {
    return str.replace(/[&<>]/g, function (tag) {
        return tagsToReplace[tag] || tag;
    });
}
function filterObjectOnKeys(obj, keys) {
    var filtered = {};
    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (typeof obj[key] !== 'undefined') {
            filtered[key] = obj[key];
        }
    }
    return filtered;
}
function convertToUnit(str) {
    var unit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'px';

    if (str == null || str === '') {
        return undefined;
    } else if (isNaN(+str)) {
        return String(str);
    } else {
        return '' + Number(str) + unit;
    }
}
function kebabCase(str) {
    return (str || '').replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
}
function isObject(obj) {
    return obj !== null && (typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) === 'object';
}
// KeyboardEvent.keyCode aliases
var keyCodes = exports.keyCodes = Object.freeze({
    enter: 13,
    tab: 9,
    delete: 46,
    esc: 27,
    space: 32,
    up: 38,
    down: 40,
    left: 37,
    right: 39,
    end: 35,
    home: 36,
    del: 46,
    backspace: 8,
    insert: 45,
    pageup: 33,
    pagedown: 34
});
var ICONS_PREFIX = '$vuetify.';
// This remaps internal names like '$vuetify.icons.cancel'
// to the current name or component for that icon.
function remapInternalIcon(vm, iconName) {
    if (!iconName.startsWith(ICONS_PREFIX)) {
        return iconName;
    }
    // Get the target icon name
    var iconPath = '$vuetify.icons.values.' + iconName.split('.').pop();
    // Now look up icon indirection name,
    // e.g. '$vuetify.icons.values.cancel'
    return getObjectValueByPath(vm, iconPath, iconName);
}
function keys(o) {
    return Object.keys(o);
}
/**
 * Camelize a hyphen-delimited string.
 */
var camelizeRE = /-(\w)/g;
var camelize = exports.camelize = function camelize(str) {
    return str.replace(camelizeRE, function (_, c) {
        return c ? c.toUpperCase() : '';
    });
};
/**
 * Returns the set difference of B and A, i.e. the set of elements in B but not in A
 */
function arrayDiff(a, b) {
    var diff = [];
    for (var i = 0; i < b.length; i++) {
        if (a.indexOf(b[i]) < 0) diff.push(b[i]);
    }
    return diff;
}
/**
 * Makes the first character of a string uppercase
 */
function upperFirst(str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
}
function groupByProperty(xs, key) {
    return xs.reduce(function (rv, x) {
        (rv[x[key]] = rv[x[key]] || []).push(x);
        return rv;
    }, {});
}
function wrapInArray(v) {
    return v != null ? Array.isArray(v) ? v : [v] : [];
}
function sortItems(items, sortBy, sortDesc, locale, customSorters) {
    if (sortBy === null || !sortBy.length) return items;
    return items.sort(function (a, b) {
        for (var i = 0; i < sortBy.length; i++) {
            var sortKey = sortBy[i];
            var sortA = getObjectValueByPath(a, sortKey);
            var sortB = getObjectValueByPath(b, sortKey);
            if (sortDesc[i]) {
                var _ref2 = [sortB, sortA];
                sortA = _ref2[0];
                sortB = _ref2[1];
            }
            if (customSorters && customSorters[sortKey]) return customSorters[sortKey](sortA, sortB);
            // Check if both cannot be evaluated
            if (sortA === null && sortB === null) {
                return 0;
            }

            var _map = [sortA, sortB].map(function (s) {
                return (s || '').toString().toLocaleLowerCase();
            });

            var _map2 = _slicedToArray(_map, 2);

            sortA = _map2[0];
            sortB = _map2[1];

            if (sortA !== sortB) {
                if (!isNaN(sortA) && !isNaN(sortB)) return Number(sortA) - Number(sortB);
                return sortA.localeCompare(sortB, locale);
            }
        }
        return 0;
    });
}
function defaultFilter(value, search) {
    return value != null && search != null && typeof value !== 'boolean' && value.toString().toLocaleLowerCase().indexOf(search.toLocaleLowerCase()) !== -1;
}
function searchItems(items, search) {
    if (!search) return items;
    search = search.toString().toLowerCase();
    if (search.trim() === '') return items;
    return items.filter(function (item) {
        return Object.keys(item).some(function (key) {
            return defaultFilter(getObjectValueByPath(item, key), search);
        });
    });
}
/**
 * Returns:
 *  - 'normal' for old style slots - `<template slot="default">`
 *  - 'scoped' for old style scoped slots (`<template slot="default" slot-scope="data">`) or bound v-slot (`#default="data"`)
 *  - 'v-slot' for unbound v-slot (`#default`) - only if the third param is true, otherwise counts as scoped
 */
function getSlotType(vm, name, split) {
    if (vm.$slots[name] && vm.$scopedSlots[name] && vm.$scopedSlots[name].name) {
        return split ? 'v-slot' : 'scoped';
    }
    if (vm.$slots[name]) return 'normal';
    if (vm.$scopedSlots[name]) return 'scoped';
}
function debounce(fn, delay) {
    var timeoutId = 0;
    return function () {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        clearTimeout(timeoutId);
        timeoutId = setTimeout(function () {
            return fn.apply(undefined, args);
        }, delay);
    };
}
function getPrefixedScopedSlots(prefix, scopedSlots) {
    return Object.keys(scopedSlots).filter(function (k) {
        return k.startsWith(prefix);
    }).reduce(function (obj, k) {
        obj[k.replace(prefix, '')] = scopedSlots[k];
        return obj;
    }, {});
}
function getSlot(vm) {
    var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'default';
    var data = arguments[2];
    var optional = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

    if (vm.$scopedSlots[name]) {
        return vm.$scopedSlots[name](data);
    } else if (vm.$slots[name] && (!data || optional)) {
        return vm.$slots[name];
    }
    return undefined;
}
function clamp(value) {
    var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

    return Math.max(min, Math.min(max, value));
}
function padEnd(str, length) {
    var char = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '0';

    return str + char.repeat(Math.max(0, length - str.length));
}
function chunk(str) {
    var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;

    var chunked = [];
    var index = 0;
    while (index < str.length) {
        chunked.push(str.substr(index, size));
        index += size;
    }
    return chunked;
}
//# sourceMappingURL=helpers.js.map