var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VApp/VApp.sass';
// Mixins
import Themeable from '../../mixins/themeable';
// Utilities
import mixins from '../../util/mixins';
/* @vue/component */
export default mixins(Themeable).extend({
    name: 'v-app',
    props: {
        dark: {
            type: Boolean,
            default: undefined
        },
        id: {
            type: String,
            default: 'app'
        },
        light: {
            type: Boolean,
            default: undefined
        }
    },
    computed: {
        isDark: function isDark() {
            if (this.dark != null || this.light != null) {
                return Themeable.options.computed.isDark.call(this);
            }
            return this.$vuetify.theme.dark;
        }
    },
    render: function render(h) {
        var wrapper = h('div', { staticClass: 'application--wrap' }, this.$slots.default);
        return h('div', {
            staticClass: 'application',
            class: _extends({
                'application--is-rtl': this.$vuetify.rtl,
                'application--is-ltr': !this.$vuetify.rtl
            }, this.themeClasses),
            attrs: { 'data-app': true },
            domProps: { id: this.id }
        }, [wrapper]);
    }
});
//# sourceMappingURL=VApp.js.map