var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Extensions
import VWindowItem from '../VWindow/VWindowItem';
// Components
import { VImg } from '../VImg';
// Utilities
import mixins from '../../util/mixins';
import Routable from '../../mixins/routable';
// Types
var baseMixins = mixins(VWindowItem, Routable);
/* @vue/component */
export default baseMixins.extend({
    name: 'v-carousel-item',
    inheritAttrs: false,
    methods: {
        genDefaultSlot: function genDefaultSlot() {
            return [this.$createElement(VImg, {
                staticClass: 'v-carousel__item',
                props: _extends({}, this.$attrs, {
                    height: this.windowGroup.internalHeight
                }),
                on: this.$listeners
            }, this.$slots.default)];
        },
        genWindowItem: function genWindowItem() {
            var _generateRouteLink = this.generateRouteLink(),
                tag = _generateRouteLink.tag,
                data = _generateRouteLink.data;

            data.staticClass = 'v-window-item';
            data.directives.push({
                name: 'show',
                value: this.isActive
            });
            return this.$createElement(tag, data, this.showLazyContent(this.genDefaultSlot()));
        },
        onBeforeEnter: function onBeforeEnter() {},
        onEnter: function onEnter() {},
        onAfterEnter: function onAfterEnter() {},
        onEnterCancelled: function onEnterCancelled() {}
    }
});
//# sourceMappingURL=VCarouselItem.js.map