'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };
// Mixins

// Util

// Types


require('../../../src/components/VIcon/VIcon.sass');

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _sizeable = require('../../mixins/sizeable');

var _sizeable2 = _interopRequireDefault(_sizeable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _helpers = require('../../util/helpers');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SIZE_MAP;
(function (SIZE_MAP) {
    SIZE_MAP["small"] = "16px";
    SIZE_MAP["default"] = "24px";
    SIZE_MAP["medium"] = "28px";
    SIZE_MAP["large"] = "36px";
    SIZE_MAP["xLarge"] = "40px";
})(SIZE_MAP || (SIZE_MAP = {}));
function isFontAwesome5(iconType) {
    return ['fas', 'far', 'fal', 'fab'].some(function (val) {
        return iconType.includes(val);
    });
}
function isSvgPath(icon) {
    return (/^[mzlhvcsqta]\s*[-+.0-9][^mlhvzcsqta]+/i.test(icon) && /[\dz]$/i.test(icon) && icon.length > 4
    );
}
var VIcon = (0, _mixins2.default)(_colorable2.default, _sizeable2.default, _themeable2.default
/* @vue/component */
).extend({
    name: 'v-icon',
    props: {
        disabled: Boolean,
        left: Boolean,
        right: Boolean,
        dense: Boolean,
        tag: {
            type: String,
            required: false,
            default: 'i'
        }
    },
    computed: {
        medium: function medium() {
            return false;
        }
    },
    methods: {
        getIcon: function getIcon() {
            var iconName = '';
            if (this.$slots.default) iconName = this.$slots.default[0].text.trim();
            return (0, _helpers.remapInternalIcon)(this, iconName);
        },
        getSize: function getSize() {
            var sizes = {
                small: this.small,
                medium: this.medium,
                large: this.large,
                xLarge: this.xLarge
            };
            var explicitSize = (0, _helpers.keys)(sizes).find(function (key) {
                return sizes[key];
            });
            return explicitSize && SIZE_MAP[explicitSize] || (0, _helpers.convertToUnit)(this.size);
        },

        // Component data for both font and svg icon.
        getDefaultData: function getDefaultData() {
            var hasClickListener = Boolean(this.$listeners.click || this.$listeners['!click']);
            var data = {
                staticClass: 'v-icon notranslate',
                class: {
                    'v-icon--disabled': this.disabled,
                    'v-icon--left': this.left,
                    'v-icon--link': hasClickListener,
                    'v-icon--right': this.right,
                    'v-icon--dense': this.dense
                },
                attrs: _extends({
                    'aria-hidden': !hasClickListener,
                    role: hasClickListener ? 'button' : null
                }, this.$attrs),
                on: this.$listeners
            };
            return data;
        },
        applyColors: function applyColors(data) {
            data.class = _extends({}, data.class, this.themeClasses);
            this.setTextColor(this.color, data);
        },
        renderFontIcon: function renderFontIcon(icon, h) {
            var newChildren = [];
            var data = this.getDefaultData();
            var iconType = 'material-icons';
            // Material Icon delimiter is _
            // https://material.io/icons/
            var delimiterIndex = icon.indexOf('-');
            var isMaterialIcon = delimiterIndex <= -1;
            if (isMaterialIcon) {
                // Material icon uses ligatures.
                newChildren.push(icon);
            } else {
                iconType = icon.slice(0, delimiterIndex);
                if (isFontAwesome5(iconType)) iconType = '';
            }
            data.class[iconType] = true;
            data.class[icon] = !isMaterialIcon;
            var fontSize = this.getSize();
            if (fontSize) data.style = { fontSize: fontSize };
            this.applyColors(data);
            return h(this.tag, data, newChildren);
        },
        renderSvgIcon: function renderSvgIcon(icon, h) {
            var data = this.getDefaultData();
            data.class['v-icon--svg'] = true;
            data.attrs = {
                xmlns: 'http://www.w3.org/2000/svg',
                viewBox: '0 0 24 24',
                height: '24',
                width: '24',
                role: 'img',
                'aria-hidden': !this.$attrs['aria-label'],
                'aria-label': this.$attrs['aria-label']
            };
            var fontSize = this.getSize();
            if (fontSize) {
                data.style = {
                    fontSize: fontSize,
                    height: fontSize,
                    width: fontSize
                };
                data.attrs.height = fontSize;
                data.attrs.width = fontSize;
            }
            this.applyColors(data);
            return h('svg', data, [h('path', {
                attrs: {
                    d: icon
                }
            })]);
        },
        renderSvgIconComponent: function renderSvgIconComponent(icon, h) {
            var data = this.getDefaultData();
            data.class['v-icon--is-component'] = true;
            var size = this.getSize();
            if (size) {
                data.style = {
                    fontSize: size,
                    height: size
                };
            }
            this.applyColors(data);
            var component = icon.component;
            data.props = icon.props;
            data.nativeOn = data.on;
            return h(component, data);
        }
    },
    render: function render(h) {
        var icon = this.getIcon();
        if (typeof icon === 'string') {
            if (isSvgPath(icon)) {
                return this.renderSvgIcon(icon, h);
            }
            return this.renderFontIcon(icon, h);
        }
        return this.renderSvgIconComponent(icon, h);
    }
});
exports.default = _vue2.default.extend({
    name: 'v-icon',
    $_wrapperFor: VIcon,
    functional: true,
    render: function render(h, _ref) {
        var data = _ref.data,
            children = _ref.children;

        var iconName = '';
        // Support usage of v-text and v-html
        if (data.domProps) {
            iconName = data.domProps.textContent || data.domProps.innerHTML || iconName;
            // Remove nodes so it doesn't
            // overwrite our changes
            delete data.domProps.textContent;
            delete data.domProps.innerHTML;
        }
        return h(VIcon, data, iconName ? [iconName] : children);
    }
});
//# sourceMappingURL=VIcon.js.map