var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VChip/VChip.sass';
import mixins from '../../util/mixins';
// Components
import { VExpandXTransition } from '../transitions';
import VIcon from '../VIcon';
// Mixins
import Colorable from '../../mixins/colorable';
import { factory as GroupableFactory } from '../../mixins/groupable';
import Themeable from '../../mixins/themeable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
import Routable from '../../mixins/routable';
import Sizeable from '../../mixins/sizeable';
// Directives
import ripple from '../../directives/ripple';
// Utilities
import { breaking } from '../../util/console';
/* @vue/component */
export default mixins(Colorable, Sizeable, Routable, Themeable, GroupableFactory('chipGroup'), ToggleableFactory('inputValue')).extend({
    name: 'v-chip',
    directives: { ripple: ripple },
    props: {
        active: {
            type: Boolean,
            default: true
        },
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.chipGroup) return '';
                return this.chipGroup.activeClass;
            }
        },
        close: Boolean,
        closeIcon: {
            type: String,
            default: '$vuetify.icons.delete'
        },
        disabled: Boolean,
        draggable: Boolean,
        filter: Boolean,
        filterIcon: {
            type: String,
            default: '$vuetify.icons.complete'
        },
        label: Boolean,
        link: Boolean,
        outlined: Boolean,
        pill: Boolean,
        tag: {
            type: String,
            default: 'span'
        },
        textColor: String,
        value: null
    },
    data: function data() {
        return {
            proxyClass: 'v-chip--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-chip': true
            }, Routable.options.computed.classes.call(this), {
                'v-chip--clickable': this.isClickable,
                'v-chip--disabled': this.disabled,
                'v-chip--draggable': this.draggable,
                'v-chip--label': this.label,
                'v-chip--link': this.isLink,
                'v-chip--no-color': !this.color,
                'v-chip--outlined': this.outlined,
                'v-chip--pill': this.pill,
                'v-chip--removable': this.hasClose
            }, this.themeClasses, this.sizeableClasses, this.groupClasses);
        },
        hasClose: function hasClose() {
            return Boolean(this.close);
        },
        isClickable: function isClickable() {
            return Boolean(Routable.options.computed.isClickable.call(this) || this.chipGroup);
        }
    },
    created: function created() {
        var _this = this;

        var breakingProps = [['outline', 'outlined'], ['selected', 'input-value'], ['value', 'active'], ['@input', '@active.sync']];
        /* istanbul ignore next */
        breakingProps.forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                original = _ref2[0],
                replacement = _ref2[1];

            if (_this.$attrs.hasOwnProperty(original)) breaking(original, replacement, _this);
        });
    },

    methods: {
        click: function click(e) {
            this.$emit('click', e);
            this.chipGroup && this.toggle();
        },
        genFilter: function genFilter() {
            var children = [];
            if (this.isActive) {
                children.push(this.$createElement(VIcon, {
                    staticClass: 'v-chip__filter',
                    props: { left: true }
                }, this.filterIcon));
            }
            return this.$createElement(VExpandXTransition, children);
        },
        genClose: function genClose() {
            var _this2 = this;

            return this.$createElement(VIcon, {
                staticClass: 'v-chip__close',
                props: {
                    right: true
                },
                on: {
                    click: function click(e) {
                        e.stopPropagation();
                        _this2.$emit('click:close');
                        _this2.$emit('update:active', false);
                    }
                }
            }, this.closeIcon);
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-chip__content'
            }, [this.filter && this.genFilter(), this.$slots.default, this.hasClose && this.genClose()]);
        }
    },
    render: function render(h) {
        var children = [this.genContent()];

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.attrs = _extends({}, data.attrs, {
            draggable: this.draggable ? 'true' : undefined,
            tabindex: this.chipGroup && !this.disabled ? 0 : data.attrs.tabindex
        });
        data.directives = [{
            name: 'show',
            value: this.active
        }];
        data = this.setBackgroundColor(this.color, data);
        var color = this.textColor || this.outlined && this.color;
        return h(tag, this.setTextColor(color, data), children);
    }
});
//# sourceMappingURL=VChip.js.map