var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Components
import { VData } from '../VData';
import VDataFooter from './VDataFooter';
// Mixins
import mixins from '../../util/mixins';
import Themeable from '../../mixins/themeable';
// Helpers
import { deepEqual, getObjectValueByPath, getPrefixedScopedSlots, getSlot } from '../../util/helpers';
import { breaking, removed } from '../../util/console';
/* @vue/component */
export default mixins(Themeable).extend({
    name: 'v-data-iterator',
    props: _extends({}, VData.options.props, {
        itemKey: {
            type: String,
            default: 'id'
        },
        value: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        singleSelect: Boolean,
        expanded: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        singleExpand: Boolean,
        loading: [Boolean, String],
        noResultsText: {
            type: String,
            default: '$vuetify.dataIterator.noResultsText'
        },
        noDataText: {
            type: String,
            default: '$vuetify.noDataText'
        },
        loadingText: {
            type: String,
            default: '$vuetify.dataIterator.loadingText'
        },
        hideDefaultFooter: Boolean,
        footerProps: Object
    }),
    data: function data() {
        return {
            selection: {},
            expansion: {},
            internalCurrentItems: []
        };
    },
    computed: {
        everyItem: function everyItem() {
            var _this = this;

            return !!this.internalCurrentItems.length && this.internalCurrentItems.every(function (i) {
                return _this.isSelected(i);
            });
        },
        someItems: function someItems() {
            var _this2 = this;

            return this.internalCurrentItems.some(function (i) {
                return _this2.isSelected(i);
            });
        }
    },
    watch: {
        value: {
            handler: function handler(value) {
                var _this3 = this;

                this.selection = value.reduce(function (selection, item) {
                    selection[getObjectValueByPath(item, _this3.itemKey)] = item;
                    return selection;
                }, {});
            },

            immediate: true
        },
        selection: function selection(value, old) {
            if (deepEqual(Object.keys(value), Object.keys(old))) return;
            this.$emit('input', Object.values(value));
        },

        expanded: {
            handler: function handler(value) {
                var _this4 = this;

                this.expansion = value.reduce(function (expansion, item) {
                    expansion[getObjectValueByPath(item, _this4.itemKey)] = true;
                    return expansion;
                }, {});
            },

            immediate: true
        },
        expansion: function expansion(value, old) {
            var _this5 = this;

            if (deepEqual(value, old)) return;
            var keys = Object.keys(value).filter(function (k) {
                return value[k];
            });
            var expanded = !keys.length ? [] : this.items.filter(function (i) {
                return keys.includes(String(getObjectValueByPath(i, _this5.itemKey)));
            });
            this.$emit('update:expanded', expanded);
        }
    },
    created: function created() {
        var _this6 = this;

        var breakingProps = [['disable-initial-sort', 'sort-by'], ['filter', 'custom-filter'], ['pagination', 'options'], ['total-items', 'server-items-length'], ['hide-actions', 'hide-default-footer'], ['rows-per-page-items', 'footer-props.items-per-page-options'], ['rows-per-page-text', 'footer-props.items-per-page-text'], ['prev-icon', 'footer-props.prev-icon'], ['next-icon', 'footer-props.next-icon']];
        /* istanbul ignore next */
        breakingProps.forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                original = _ref2[0],
                replacement = _ref2[1];

            if (_this6.$attrs.hasOwnProperty(original)) breaking(original, replacement, _this6);
        });
        var removedProps = ['expand', 'content-class', 'content-props', 'content-tag'];
        /* istanbul ignore next */
        removedProps.forEach(function (prop) {
            if (_this6.$attrs.hasOwnProperty(prop)) removed(prop);
        });
    },

    methods: {
        toggleSelectAll: function toggleSelectAll(value) {
            var _this7 = this;

            var selection = Object.assign({}, this.selection);
            this.internalCurrentItems.forEach(function (item) {
                var key = getObjectValueByPath(item, _this7.itemKey);
                if (value) selection[key] = item;else delete selection[key];
            });
            this.selection = selection;
        },
        isSelected: function isSelected(item) {
            return !!this.selection[getObjectValueByPath(item, this.itemKey)] || false;
        },
        select: function select(item) {
            var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
            var emit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

            var selection = this.singleSelect ? {} : Object.assign({}, this.selection);
            var key = getObjectValueByPath(item, this.itemKey);
            if (value) selection[key] = item;else delete selection[key];
            this.selection = selection;
            emit && this.$emit('item-selected', { item: item, value: value });
        },
        isExpanded: function isExpanded(item) {
            return this.expansion[getObjectValueByPath(item, this.itemKey)] || false;
        },
        expand: function expand(item) {
            var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

            var expansion = this.singleExpand ? {} : Object.assign({}, this.expansion);
            var key = getObjectValueByPath(item, this.itemKey);
            if (value) expansion[key] = true;else delete expansion[key];
            this.expansion = expansion;
            this.$emit('item-expanded', { item: item, value: value });
        },
        createItemProps: function createItemProps(item) {
            var _this8 = this;

            var props = {
                item: item,
                select: {
                    props: {
                        value: this.isSelected(item)
                    },
                    on: {
                        input: function input(v) {
                            return _this8.select(item, v);
                        }
                    }
                },
                expand: {
                    props: {
                        value: this.isExpanded(item)
                    },
                    on: {
                        input: function input(v) {
                            return _this8.expand(item, v);
                        }
                    }
                }
            };
            return props;
        },
        genEmptyWrapper: function genEmptyWrapper(content) {
            return this.$createElement('div', content);
        },
        genEmpty: function genEmpty(itemsLength) {
            if (itemsLength <= 0 && this.loading) {
                var loading = this.$slots['loading'] || this.$vuetify.lang.t(this.loadingText);
                return this.genEmptyWrapper(loading);
            } else if (itemsLength <= 0 && !this.items.length) {
                var noData = this.$slots['no-data'] || this.$vuetify.lang.t(this.noDataText);
                return this.genEmptyWrapper(noData);
            } else if (itemsLength <= 0 && this.search) {
                var noResults = this.$slots['no-results'] || this.$vuetify.lang.t(this.noResultsText);
                return this.genEmptyWrapper(noResults);
            }
            return null;
        },
        genItems: function genItems(props) {
            var _this9 = this;

            var empty = this.genEmpty(props.pagination.itemsLength);
            if (empty) return [empty];
            if (this.$scopedSlots.default) {
                return this.$scopedSlots.default(_extends({}, props, {
                    isSelected: this.isSelected,
                    select: this.select,
                    isExpanded: this.isExpanded,
                    expand: this.expand
                }));
            }
            if (this.$scopedSlots.item) {
                return props.items.map(function (item) {
                    return _this9.$scopedSlots.item(_this9.createItemProps(item));
                });
            }
            return [];
        },
        genFooter: function genFooter(props) {
            if (this.hideDefaultFooter) return null;
            var data = {
                props: _extends({}, this.footerProps, {
                    options: props.options,
                    pagination: props.pagination
                }),
                on: {
                    'update:options': function updateOptions(value) {
                        return props.updateOptions(value);
                    }
                }
            };
            var scopedSlots = getPrefixedScopedSlots('footer.', this.$scopedSlots);
            return this.$createElement(VDataFooter, _extends({
                scopedSlots: scopedSlots
            }, data));
        },
        genDefaultScopedSlot: function genDefaultScopedSlot(props) {
            var outerProps = _extends({}, props, {
                someItems: this.someItems,
                everyItem: this.everyItem,
                toggleSelectAll: this.toggleSelectAll
            });
            return this.$createElement('div', {
                staticClass: 'v-data-iterator'
            }, [getSlot(this, 'header', outerProps, true), this.genItems(props), this.genFooter(props), getSlot(this, 'footer', outerProps, true)]);
        }
    },
    render: function render() {
        var _this10 = this;

        return this.$createElement(VData, {
            props: this.$props,
            on: {
                'update:options': function updateOptions(v, old) {
                    return !deepEqual(v, old) && _this10.$emit('update:options', v);
                },
                'update:page': function updatePage(v) {
                    return _this10.$emit('update:page', v);
                },
                'update:items-per-page': function updateItemsPerPage(v) {
                    return _this10.$emit('update:items-per-page', v);
                },
                'update:sort-by': function updateSortBy(v) {
                    return _this10.$emit('update:sort-by', v);
                },
                'update:sort-desc': function updateSortDesc(v) {
                    return _this10.$emit('update:sort-desc', v);
                },
                'update:group-by': function updateGroupBy(v) {
                    return _this10.$emit('update:group-by', v);
                },
                'update:group-desc': function updateGroupDesc(v) {
                    return _this10.$emit('update:group-desc', v);
                },
                'pagination': function pagination(v, old) {
                    return !deepEqual(v, old) && _this10.$emit('pagination', v);
                },
                'current-items': function currentItems(v) {
                    _this10.internalCurrentItems = v;
                    _this10.$emit('current-items', v);
                }
            },
            scopedSlots: {
                default: this.genDefaultScopedSlot
            }
        });
    }
});
//# sourceMappingURL=VDataIterator.js.map