function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

export function genPoints(values, boundary) {
    var minX = boundary.minX,
        maxX = boundary.maxX,
        minY = boundary.minY,
        maxY = boundary.maxY;

    var totalValues = values.length;
    var maxValue = Math.max.apply(Math, _toConsumableArray(values));
    var minValue = Math.min.apply(Math, _toConsumableArray(values));
    var gridX = (maxX - minX) / (totalValues - 1);
    var gridY = (maxY - minY) / (maxValue - minValue);
    return values.map(function (value, index) {
        return {
            x: minX + index * gridX,
            y: maxY - (value - minValue) * gridY + +(index === totalValues - 1) * 0.00001 - +(index === 0) * 0.00001,
            value: value
        };
    });
}
export function genBars(values, boundary) {
    var minX = boundary.minX,
        maxX = boundary.maxX,
        minY = boundary.minY,
        maxY = boundary.maxY;

    var totalValues = values.length;
    var maxValue = Math.max.apply(Math, _toConsumableArray(values));
    var minValue = Math.min.apply(Math, _toConsumableArray(values));
    var gridX = maxX / totalValues;
    var gridY = (maxY - minY) / (maxValue - minValue);
    var horizonY = maxY - Math.abs(minValue * gridY);
    return values.map(function (value, index) {
        var height = Math.abs(gridY * value);
        return {
            x: minX + index * gridX,
            y: horizonY - height + +(value < 0) * height,
            height: height,
            value: value
        };
    });
}
//# sourceMappingURL=core.js.map