var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VWindow/VWindow.sass';
// Components
import VBtn from '../VBtn';
import VIcon from '../VIcon';
import { BaseItemGroup } from '../VItemGroup/VItemGroup';
// Directives
import Touch from '../../directives/touch';
/* @vue/component */
export default BaseItemGroup.extend({
    name: 'v-window',
    provide: function provide() {
        return {
            windowGroup: this
        };
    },

    directives: { Touch: Touch },
    props: {
        activeClass: {
            type: String,
            default: 'v-window-item--active'
        },
        continuous: Boolean,
        mandatory: {
            type: Boolean,
            default: true
        },
        nextIcon: {
            type: [Boolean, String],
            default: '$vuetify.icons.next'
        },
        prevIcon: {
            type: [Boolean, String],
            default: '$vuetify.icons.prev'
        },
        reverse: {
            type: Boolean,
            default: undefined
        },
        showArrows: Boolean,
        showArrowsOnHover: Boolean,
        touch: Object,
        touchless: Boolean,
        value: {
            required: false
        },
        vertical: Boolean
    },
    data: function data() {
        return {
            changedByDelimiters: false,
            internalHeight: undefined,
            isActive: false,
            isBooted: false,
            isReverse: false
        };
    },

    computed: {
        classes: function classes() {
            return _extends({}, BaseItemGroup.options.computed.classes.call(this), {
                'v-window--show-arrows-on-hover': this.showArrowsOnHover
            });
        },
        computedTransition: function computedTransition() {
            if (!this.isBooted) return '';
            var axis = this.vertical ? 'y' : 'x';
            var direction = this.internalReverse ? '-reverse' : '';
            return 'v-window-' + axis + direction + '-transition';
        },
        hasActiveItems: function hasActiveItems() {
            return Boolean(this.items.find(function (item) {
                return !item.disabled;
            }));
        },
        hasNext: function hasNext() {
            return this.continuous || this.internalIndex < this.items.length - 1;
        },
        hasPrev: function hasPrev() {
            return this.continuous || this.internalIndex > 0;
        },
        internalIndex: function internalIndex() {
            var _this = this;

            return this.items.findIndex(function (item, i) {
                return _this.internalValue === _this.getValue(item, i);
            });
        },
        internalReverse: function internalReverse() {
            if (this.reverse !== undefined) return this.reverse;
            return this.isReverse;
        }
    },
    watch: {
        internalIndex: 'updateReverse'
    },
    mounted: function mounted() {
        var _this2 = this;

        window.requestAnimationFrame(function () {
            return _this2.isBooted = true;
        });
    },

    methods: {
        genContainer: function genContainer() {
            var children = [this.$slots.default];
            if (this.showArrows) {
                children.push(this.genControlIcons());
            }
            return this.$createElement('div', {
                staticClass: 'v-window__container',
                class: {
                    'v-window__container--is-active': this.isActive
                },
                style: {
                    height: this.internalHeight
                }
            }, children);
        },
        genIcon: function genIcon(direction, icon, fn) {
            var _this3 = this;

            return this.$createElement('div', {
                staticClass: 'v-window__' + direction
            }, [this.$createElement(VBtn, {
                props: {
                    icon: true
                },
                attrs: {
                    'aria-label': this.$vuetify.lang.t('$vuetify.carousel.' + direction)
                },
                on: {
                    click: function click() {
                        _this3.changedByDelimiters = true;
                        fn();
                    }
                }
            }, [this.$createElement(VIcon, {
                props: { size: 40 }
            }, icon)])]);
        },
        genControlIcons: function genControlIcons() {
            var icons = [];
            var prevIcon = this.$vuetify.rtl ? this.nextIcon : this.prevIcon;
            /* istanbul ignore else */
            if (this.hasPrev && prevIcon && typeof prevIcon === 'string') {
                var icon = this.genIcon('prev', prevIcon, this.prev);
                icon && icons.push(icon);
            }
            var nextIcon = this.$vuetify.rtl ? this.prevIcon : this.nextIcon;
            /* istanbul ignore else */
            if (this.hasNext && nextIcon && typeof nextIcon === 'string') {
                var _icon = this.genIcon('next', nextIcon, this.next);
                _icon && icons.push(_icon);
            }
            return icons;
        },
        getNextIndex: function getNextIndex(index) {
            var nextIndex = (index + 1) % this.items.length;
            var item = this.items[nextIndex];
            if (item.disabled) return this.getNextIndex(nextIndex);
            return nextIndex;
        },
        getPrevIndex: function getPrevIndex(index) {
            var prevIndex = (index + this.items.length - 1) % this.items.length;
            var item = this.items[prevIndex];
            if (item.disabled) return this.getPrevIndex(prevIndex);
            return prevIndex;
        },
        next: function next() {
            this.isReverse = this.$vuetify.rtl;
            /* istanbul ignore if */
            if (!this.hasActiveItems) return;
            var nextIndex = this.getNextIndex(this.internalIndex);
            var item = this.items[nextIndex];
            this.internalValue = this.getValue(item, nextIndex);
        },
        prev: function prev() {
            this.isReverse = !this.$vuetify.rtl;
            /* istanbul ignore if */
            if (!this.hasActiveItems) return;
            var lastIndex = this.getPrevIndex(this.internalIndex);
            var item = this.items[lastIndex];
            this.internalValue = this.getValue(item, lastIndex);
        },
        updateReverse: function updateReverse(val, oldVal) {
            if (this.changedByDelimiters) {
                this.changedByDelimiters = false;
                return;
            }
            this.isReverse = val < oldVal;
        }
    },
    render: function render(h) {
        var _this4 = this;

        var data = {
            staticClass: 'v-window',
            class: this.classes,
            directives: []
        };
        if (!this.touchless) {
            var value = this.touch || {
                left: function left() {
                    _this4.$vuetify.rtl ? _this4.prev() : _this4.next();
                },
                right: function right() {
                    _this4.$vuetify.rtl ? _this4.next() : _this4.prev();
                },
                end: function end(e) {
                    e.stopPropagation();
                },
                start: function start(e) {
                    e.stopPropagation();
                }
            };
            data.directives.push({
                name: 'touch',
                value: value
            });
        }
        return h('div', data, [this.genContainer()]);
    }
});
//# sourceMappingURL=VWindow.js.map