'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VApp/VApp.sass');

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_themeable2.default).extend({
    name: 'v-app',
    props: {
        dark: {
            type: Boolean,
            default: undefined
        },
        id: {
            type: String,
            default: 'app'
        },
        light: {
            type: Boolean,
            default: undefined
        }
    },
    render: function render(h) {
        var wrapper = h('div', { staticClass: 'v-application--wrap' }, this.$slots.default);
        return h('div', {
            staticClass: 'v-application',
            class: _extends({
                'v-application--is-rtl': this.$vuetify.rtl,
                'v-application--is-ltr': !this.$vuetify.rtl
            }, this.themeClasses),
            attrs: { 'data-app': true },
            domProps: { id: this.id }
        }, [wrapper]);
    }
});
//# sourceMappingURL=VApp.js.map