'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Extensions

// Components

// Utilities


var _VWindowItem = require('../VWindow/VWindowItem');

var _VWindowItem2 = _interopRequireDefault(_VWindowItem);

var _VImg = require('../VImg');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _routable = require('../../mixins/routable');

var _routable2 = _interopRequireDefault(_routable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Types
var baseMixins = (0, _mixins2.default)(_VWindowItem2.default, _routable2.default);
/* @vue/component */
exports.default = baseMixins.extend({
    name: 'v-carousel-item',
    inheritAttrs: false,
    methods: {
        genDefaultSlot: function genDefaultSlot() {
            return [this.$createElement(_VImg.VImg, {
                staticClass: 'v-carousel__item',
                props: _extends({}, this.$attrs, {
                    height: this.windowGroup.internalHeight
                }),
                on: this.$listeners
            }, this.$slots.default)];
        },
        genWindowItem: function genWindowItem() {
            var _generateRouteLink = this.generateRouteLink(),
                tag = _generateRouteLink.tag,
                data = _generateRouteLink.data;

            data.staticClass = 'v-window-item';
            data.directives.push({
                name: 'show',
                value: this.isActive
            });
            return this.$createElement(tag, data, this.showLazyContent(this.genDefaultSlot()));
        },
        onBeforeEnter: function onBeforeEnter() {},
        onEnter: function onEnter() {},
        onAfterEnter: function onAfterEnter() {},
        onEnterCancelled: function onEnterCancelled() {}
    }
});
//# sourceMappingURL=VCarouselItem.js.map