'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _VIcon = require('../../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VSimpleCheckbox = require('../../VCheckbox/VSimpleCheckbox');

var _VSimpleCheckbox2 = _interopRequireDefault(_VSimpleCheckbox);

var _ripple = require('../../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _mixins = require('../../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)().extend({
    // https://github.com/vuejs/vue/issues/6872
    directives: {
        ripple: _ripple2.default
    },
    props: {
        headers: {
            type: Array,
            required: true
        },
        options: {
            type: Object,
            default: function _default() {
                return {
                    page: 1,
                    itemsPerPage: 10,
                    sortBy: [],
                    sortDesc: [],
                    groupBy: [],
                    groupDesc: [],
                    multiSort: false,
                    mustSort: false
                };
            }
        },
        sortIcon: {
            type: String,
            default: '$vuetify.icons.sort'
        },
        everyItem: Boolean,
        someItems: Boolean,
        showGroupBy: Boolean,
        singleSelect: Boolean,
        disableSort: Boolean
    },
    methods: {
        genSelectAll: function genSelectAll() {
            var _this = this;

            var data = {
                props: {
                    value: this.everyItem,
                    indeterminate: !this.everyItem && this.someItems
                },
                on: {
                    input: function input(v) {
                        return _this.$emit('toggle-select-all', v);
                    }
                }
            };
            if (this.$scopedSlots['data-table-select']) {
                return this.$scopedSlots['data-table-select'](data);
            }
            return this.$createElement(_VSimpleCheckbox2.default, _extends({
                staticClass: 'v-data-table__checkbox'
            }, data));
        },
        genSortIcon: function genSortIcon() {
            return this.$createElement(_VIcon2.default, {
                props: {
                    size: 18
                }
            }, [this.sortIcon]);
        }
    }
});
//# sourceMappingURL=header.js.map