'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VDialog/VDialog.sass');

var _activatable = require('../../mixins/activatable');

var _activatable2 = _interopRequireDefault(_activatable);

var _dependent = require('../../mixins/dependent');

var _dependent2 = _interopRequireDefault(_dependent);

var _detachable = require('../../mixins/detachable');

var _detachable2 = _interopRequireDefault(_detachable);

var _overlayable = require('../../mixins/overlayable');

var _overlayable2 = _interopRequireDefault(_overlayable);

var _returnable = require('../../mixins/returnable');

var _returnable2 = _interopRequireDefault(_returnable);

var _stackable = require('../../mixins/stackable');

var _stackable2 = _interopRequireDefault(_stackable);

var _toggleable = require('../../mixins/toggleable');

var _toggleable2 = _interopRequireDefault(_toggleable);

var _clickOutside = require('../../directives/click-outside');

var _clickOutside2 = _interopRequireDefault(_clickOutside);

var _helpers = require('../../util/helpers');

var _ThemeProvider = require('../../util/ThemeProvider');

var _ThemeProvider2 = _interopRequireDefault(_ThemeProvider);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
// Mixins

// Directives

// Helpers


var baseMixins = (0, _mixins2.default)(_activatable2.default, _dependent2.default, _detachable2.default, _overlayable2.default, _returnable2.default, _stackable2.default, _toggleable2.default);
/* @vue/component */
exports.default = baseMixins.extend({
    name: 'v-dialog',
    directives: {
        ClickOutside: _clickOutside2.default
    },
    props: {
        dark: Boolean,
        disabled: Boolean,
        fullscreen: Boolean,
        fullWidth: Boolean,
        light: Boolean,
        maxWidth: {
            type: [String, Number],
            default: 'none'
        },
        noClickAnimation: Boolean,
        origin: {
            type: String,
            default: 'center center'
        },
        persistent: Boolean,
        scrollable: Boolean,
        transition: {
            type: [String, Boolean],
            default: 'dialog-transition'
        },
        width: {
            type: [String, Number],
            default: 'auto'
        }
    },
    data: function data() {
        return {
            activatedBy: null,
            animate: false,
            animateTimeout: -1,
            isActive: !!this.value,
            stackMinZIndex: 200
        };
    },

    computed: {
        classes: function classes() {
            var _ref;

            return _ref = {}, _defineProperty(_ref, ('v-dialog ' + this.contentClass).trim(), true), _defineProperty(_ref, 'v-dialog--active', this.isActive), _defineProperty(_ref, 'v-dialog--persistent', this.persistent), _defineProperty(_ref, 'v-dialog--fullscreen', this.fullscreen), _defineProperty(_ref, 'v-dialog--scrollable', this.scrollable), _defineProperty(_ref, 'v-dialog--animated', this.animate), _ref;
        },
        contentClasses: function contentClasses() {
            return {
                'v-dialog__content': true,
                'v-dialog__content--active': this.isActive
            };
        },
        hasActivator: function hasActivator() {
            return Boolean(!!this.$slots.activator || !!this.$scopedSlots.activator);
        }
    },
    watch: {
        isActive: function isActive(val) {
            if (val) {
                this.show();
                this.hideScroll();
            } else {
                this.removeOverlay();
                this.unbind();
            }
        },
        fullscreen: function fullscreen(val) {
            if (!this.isActive) return;
            if (val) {
                this.hideScroll();
                this.removeOverlay(false);
            } else {
                this.showScroll();
                this.genOverlay();
            }
        }
    },
    beforeMount: function beforeMount() {
        var _this = this;

        this.$nextTick(function () {
            _this.isBooted = _this.isActive;
            _this.isActive && _this.show();
        });
    },
    beforeDestroy: function beforeDestroy() {
        if (typeof window !== 'undefined') this.unbind();
    },

    methods: {
        animateClick: function animateClick() {
            var _this2 = this;

            this.animate = false;
            // Needed for when clicking very fast
            // outside of the dialog
            this.$nextTick(function () {
                _this2.animate = true;
                window.clearTimeout(_this2.animateTimeout);
                _this2.animateTimeout = window.setTimeout(function () {
                    return _this2.animate = false;
                }, 150);
            });
        },
        closeConditional: function closeConditional(e) {
            var target = e.target;
            // If the dialog content contains
            // the click event, or if the
            // dialog is not active
            if (!this.isActive || this.$refs.content.contains(target)) return false;
            // If we made it here, the click is outside
            // and is active. If persistent, and the
            // click is on the overlay, animate
            this.$emit('click:outside');
            if (this.persistent) {
                if (!this.noClickAnimation && this.overlay === target) this.animateClick();
                return false;
            }
            // close dialog if !persistent, clicked outside and we're the topmost dialog.
            // Since this should only be called in a capture event (bottom up), we shouldn't need to stop propagation
            return this.activeZIndex >= this.getMaxZIndex();
        },
        hideScroll: function hideScroll() {
            if (this.fullscreen) {
                document.documentElement.classList.add('overflow-y-hidden');
            } else {
                _overlayable2.default.options.methods.hideScroll.call(this);
            }
        },
        show: function show() {
            !this.fullscreen && !this.hideOverlay && this.genOverlay();
            this.$refs.content.focus();
            this.bind();
        },
        bind: function bind() {
            window.addEventListener('focusin', this.onFocusin);
        },
        unbind: function unbind() {
            window.removeEventListener('focusin', this.onFocusin);
        },
        onKeydown: function onKeydown(e) {
            if (e.keyCode === _helpers.keyCodes.esc && !this.getOpenDependents().length) {
                if (!this.persistent) {
                    this.isActive = false;
                    var activator = this.getActivator();
                    this.$nextTick(function () {
                        return activator && activator.focus();
                    });
                } else if (!this.noClickAnimation) {
                    this.animateClick();
                }
            }
            this.$emit('keydown', e);
        },
        onFocusin: function onFocusin(e) {
            if (!e) return;
            var target = e.target;
            if (!!target &&
            // It isn't the document or the dialog body
            ![document, this.$refs.content].includes(target) &&
            // It isn't inside the dialog body
            !this.$refs.content.contains(target) &&
            // We're the topmost dialog
            this.activeZIndex >= this.getMaxZIndex() &&
            // It isn't inside a dependent element (like a menu)
            !this.getOpenDependentElements().some(function (el) {
                return el.contains(target);
            })
            // So we must have focused something outside the dialog and its children
            ) {
                    // Find and focus the first available element inside the dialog
                    var focusable = this.$refs.content.querySelectorAll('button, [href], input, select, textarea, [tabindex]:not([tabindex="-1"])');
                    focusable.length && focusable[0].focus();
                }
        }
    },
    render: function render(h) {
        var _this3 = this;

        var children = [];
        var data = {
            'class': this.classes,
            ref: 'dialog',
            directives: [{
                name: 'click-outside',
                value: function value() {
                    _this3.isActive = false;
                },
                args: {
                    closeConditional: this.closeConditional,
                    include: this.getOpenDependentElements
                }
            }, { name: 'show', value: this.isActive }],
            on: {
                click: function click(e) {
                    e.stopPropagation();
                }
            },
            style: {}
        };
        if (!this.fullscreen) {
            data.style = {
                maxWidth: this.maxWidth === 'none' ? undefined : (0, _helpers.convertToUnit)(this.maxWidth),
                width: this.width === 'auto' ? undefined : (0, _helpers.convertToUnit)(this.width)
            };
        }
        children.push(this.genActivator());
        var dialog = h('div', data, this.showLazyContent(this.getContentSlot()));
        if (this.transition) {
            dialog = h('transition', {
                props: {
                    name: this.transition,
                    origin: this.origin
                }
            }, [dialog]);
        }
        children.push(h('div', {
            'class': this.contentClasses,
            attrs: _extends({
                role: 'document',
                tabindex: 0
            }, this.getScopeIdAttrs()),
            on: {
                keydown: this.onKeydown
            },
            style: { zIndex: this.activeZIndex },
            ref: 'content'
        }, [this.$createElement(_ThemeProvider2.default, {
            props: {
                root: true,
                light: this.light,
                dark: this.dark
            }
        }, [dialog])]));
        return h('div', {
            staticClass: 'v-dialog__container',
            attrs: { role: 'dialog' },
            style: {
                display: !this.hasActivator || this.fullWidth ? 'block' : 'inline-block'
            }
        }, children);
    }
});
//# sourceMappingURL=VDialog.js.map