'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VOverlay/VOverlay.sass');

var _colorable = require('./../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _toggleable = require('./../../mixins/toggleable');

var _toggleable2 = _interopRequireDefault(_toggleable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_colorable2.default, _themeable2.default, _toggleable2.default).extend({
    name: 'v-overlay',
    props: {
        absolute: Boolean,
        color: {
            type: String,
            default: '#212121'
        },
        dark: {
            type: Boolean,
            default: true
        },
        opacity: {
            type: [Number, String],
            default: 0.46
        },
        zIndex: {
            type: [Number, String],
            default: 5
        },
        value: {
            default: true
        }
    },
    computed: {
        __scrim: function __scrim() {
            var data = this.setBackgroundColor(this.color, {
                staticClass: 'v-overlay__scrim',
                style: {
                    opacity: this.computedOpacity
                }
            });
            return this.$createElement('div', data);
        },
        classes: function classes() {
            return _extends({
                'v-overlay--absolute': this.absolute,
                'v-overlay--active': this.isActive
            }, this.themeClasses);
        },
        computedOpacity: function computedOpacity() {
            return Number(this.isActive ? this.opacity : 0);
        },
        styles: function styles() {
            return {
                zIndex: this.zIndex
            };
        }
    },
    methods: {
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-overlay__content'
            }, this.$slots.default);
        }
    },
    render: function render(h) {
        var children = [this.__scrim];
        if (this.isActive) children.push(this.genContent());
        return h('div', {
            staticClass: 'v-overlay',
            class: this.classes,
            style: this.styles
        }, children);
    }
});
//# sourceMappingURL=VOverlay.js.map