'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VRadioGroup/VRadio.sass');

var _VLabel = require('../VLabel');

var _VLabel2 = _interopRequireDefault(_VLabel);

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VInput = require('../VInput');

var _VInput2 = _interopRequireDefault(_VInput);

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _groupable = require('../../mixins/groupable');

var _rippleable = require('../../mixins/rippleable');

var _rippleable2 = _interopRequireDefault(_rippleable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _selectable = require('../../mixins/selectable');

var _selectable2 = _interopRequireDefault(_selectable);

var _helpers = require('../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)(_colorable2.default, _rippleable2.default, (0, _groupable.factory)('radioGroup'), _themeable2.default);
/* @vue/component */
exports.default = baseMixins.extend().extend({
    name: 'v-radio',
    inheritAttrs: false,
    props: {
        color: {
            type: String,
            default: 'accent'
        },
        disabled: Boolean,
        label: String,
        name: String,
        id: String,
        onIcon: {
            type: String,
            default: '$vuetify.icons.radioOn'
        },
        offIcon: {
            type: String,
            default: '$vuetify.icons.radioOff'
        },
        readonly: Boolean,
        value: {
            default: null
        }
    },
    data: function data() {
        return {
            isFocused: false
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-radio--is-disabled': this.isDisabled,
                'v-radio--is-focused': this.isFocused
            }, this.themeClasses, this.groupClasses);
        },
        computedColor: function computedColor() {
            var color = (this.radioGroup || {}).validationState;
            return this.isActive ? this.color : color || false;
        },
        computedIcon: function computedIcon() {
            return this.isActive ? this.onIcon : this.offIcon;
        },
        computedId: function computedId() {
            return _VInput2.default.options.computed.computedId.call(this);
        },

        hasLabel: _VInput2.default.options.computed.hasLabel,
        hasState: function hasState() {
            return (this.radioGroup || {}).hasState;
        },
        isDisabled: function isDisabled() {
            return this.disabled || !!(this.radioGroup || {}).disabled;
        },
        isReadonly: function isReadonly() {
            return this.readonly || !!(this.radioGroup || {}).readonly;
        },
        computedName: function computedName() {
            if (this.name || !this.radioGroup) {
                return this.name;
            }
            return this.radioGroup.name || 'radio-' + this.radioGroup._uid;
        }
    },
    methods: {
        genInput: function genInput(args) {
            // We can't actually use the mixin directly because
            // it's made for standalone components, but its
            // genInput method is exactly what we need
            return _selectable2.default.options.methods.genInput.call(this, 'radio', args);
        },
        genLabel: function genLabel() {
            var _this = this;

            if (!this.hasLabel) return null;
            return this.$createElement(_VLabel2.default, {
                on: {
                    click: function click(e) {
                        // Prevent label from
                        // causing the input
                        // to focus
                        e.preventDefault();
                        _this.onChange();
                    }
                },
                attrs: {
                    for: this.computedId
                },
                props: {
                    color: (this.radioGroup || {}).validationState || '',
                    focused: this.hasState
                }
            }, (0, _helpers.getSlot)(this, 'label') || this.label);
        },
        genRadio: function genRadio() {
            return this.$createElement('div', {
                staticClass: 'v-input--selection-controls__input'
            }, [this.genInput(_extends({
                name: this.computedName,
                value: this.value
            }, this.$attrs)), this.genRipple(this.setTextColor(this.computedColor)), this.$createElement(_VIcon2.default, this.setTextColor(this.computedColor, {}), this.computedIcon)]);
        },
        onFocus: function onFocus(e) {
            this.isFocused = true;
            this.$emit('focus', e);
        },
        onBlur: function onBlur(e) {
            this.isFocused = false;
            this.$emit('blur', e);
        },
        onChange: function onChange() {
            if (this.isDisabled || this.isReadonly || this.isActive) return;
            this.toggle();
        },

        onKeydown: function onKeydown() {}
    },
    render: function render(h) {
        var data = {
            staticClass: 'v-radio',
            class: this.classes
        };
        if ((this.radioGroup || {}).hasError) {
            data = this.setTextColor(this.color, data);
        }
        return h('div', data, [this.genRadio(), this.genLabel()]);
    }
});
//# sourceMappingURL=VRadio.js.map