'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VSystemBar/VSystemBar.sass');

var _applicationable = require('../../mixins/applicationable');

var _applicationable2 = _interopRequireDefault(_applicationable);

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)((0, _applicationable2.default)('bar', ['height', 'window']), _colorable2.default, _themeable2.default
/* @vue/component */
).extend({
    name: 'v-system-bar',
    props: {
        height: [Number, String],
        lightsOut: Boolean,
        window: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-system-bar--lights-out': this.lightsOut,
                'v-system-bar--absolute': this.absolute,
                'v-system-bar--fixed': !this.absolute && (this.app || this.fixed),
                'v-system-bar--window': this.window
            }, this.themeClasses);
        },
        computedHeight: function computedHeight() {
            if (this.height) {
                return isNaN(parseInt(this.height)) ? this.height : parseInt(this.height);
            }
            return this.window ? 32 : 24;
        },
        styles: function styles() {
            return {
                height: (0, _helpers.convertToUnit)(this.computedHeight)
            };
        }
    },
    methods: {
        updateApplication: function updateApplication() {
            return this.$el ? this.$el.clientHeight : this.computedHeight;
        }
    },
    render: function render(h) {
        var data = {
            staticClass: 'v-system-bar',
            class: this.classes,
            style: this.styles
        };
        return h('div', this.setBackgroundColor(this.color, data), (0, _helpers.getSlot)(this));
    }
});
//# sourceMappingURL=VSystemBar.js.map