var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Extensions
import VWindow from '../VWindow/VWindow';
// Types & Components
import { BaseItemGroup } from './../VItemGroup/VItemGroup';
/* @vue/component */
export default VWindow.extend({
    name: 'v-tabs-items',
    props: {
        mandatory: {
            type: Boolean,
            default: false
        }
    },
    computed: {
        classes: function classes() {
            return _extends({}, VWindow.options.computed.classes.call(this), {
                'v-tabs-items': true
            });
        }
    },
    methods: {
        getValue: function getValue(item, i) {
            return item.id || BaseItemGroup.options.methods.getValue.call(this, item, i);
        }
    }
});
//# sourceMappingURL=VTabsItems.js.map