import { parseTimestamp, getDayIdentifier, getTimestampIdentifier } from './timestamp';
export function parseEvent(input, index, startProperty, endProperty) {
    if (!(startProperty in input)) {
        throw new Error('The ' + startProperty + ' property is required on all events to be a valid timestamp in the format YYYY-MM-DD or YYYY-MM-DD hh:mm');
    }
    var start = parseTimestamp(input[startProperty]);
    var end = input[endProperty] ? parseTimestamp(input[endProperty]) : start;
    var startIdentifier = getDayIdentifier(start);
    var startTimestampIdentifier = getTimestampIdentifier(start);
    var endIdentifier = getDayIdentifier(end);
    var endTimestampIdentifier = getTimestampIdentifier(end);
    var allDay = !start.hasTime;
    return { input: input, start: start, startIdentifier: startIdentifier, startTimestampIdentifier: startTimestampIdentifier, end: end, endIdentifier: endIdentifier, endTimestampIdentifier: endTimestampIdentifier, allDay: allDay, index: index };
}
export function isEventOn(event, dayIdentifier) {
    return dayIdentifier >= event.startIdentifier && dayIdentifier <= event.endIdentifier;
}
export function isEventOverlapping(event, startIdentifier, endIdentifier) {
    return startIdentifier <= event.endIdentifier && endIdentifier >= event.startIdentifier;
}
//# sourceMappingURL=events.js.map