var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Components
import { VFadeTransition } from '../transitions';
import VIcon from '../VIcon';
// Mixins
import { inject as RegistrableInject } from '../../mixins/registrable';
// Directives
import ripple from '../../directives/ripple';
// Utilities
import { getSlot } from '../../util/helpers';
import mixins from '../../util/mixins';
var baseMixins = mixins(RegistrableInject('expansionPanel', 'v-expansion-panel-header', 'v-expansion-panel'));
export default baseMixins.extend().extend({
    name: 'v-expansion-panel-header',
    directives: { ripple: ripple },
    props: {
        disableIconRotate: Boolean,
        expandIcon: {
            type: String,
            default: '$vuetify.icons.expand'
        },
        hideActions: Boolean,
        ripple: {
            type: [Boolean, Object],
            default: false
        }
    },
    data: function data() {
        return {
            hasMousedown: false
        };
    },
    computed: {
        classes: function classes() {
            return {
                'v-expansion-panel-header--active': this.isActive,
                'v-expansion-panel-header--mousedown': this.hasMousedown
            };
        },
        isActive: function isActive() {
            return this.expansionPanel.isActive;
        },
        isDisabled: function isDisabled() {
            return this.expansionPanel.isDisabled;
        },
        isReadonly: function isReadonly() {
            return this.expansionPanel.isReadonly;
        }
    },
    created: function created() {
        this.expansionPanel.registerHeader(this);
    },
    beforeDestroy: function beforeDestroy() {
        this.expansionPanel.unregisterHeader();
    },

    methods: {
        onClick: function onClick(e) {
            this.$emit('click', e);
        },
        genIcon: function genIcon() {
            var icon = getSlot(this, 'actions') || [this.$createElement(VIcon, this.expandIcon)];
            return this.$createElement(VFadeTransition, [this.$createElement('div', {
                staticClass: 'v-expansion-panel-header__icon',
                class: {
                    'v-expansion-panel-header__icon--disable-rotate': this.disableIconRotate
                },
                directives: [{
                    name: 'show',
                    value: !this.isDisabled
                }]
            }, icon)]);
        }
    },
    render: function render(h) {
        var _this = this;

        return h('button', {
            staticClass: 'v-expansion-panel-header',
            class: this.classes,
            attrs: {
                tabindex: this.isDisabled ? -1 : null,
                type: 'button'
            },
            directives: [{
                name: 'ripple',
                value: this.ripple
            }],
            on: _extends({}, this.$listeners, {
                click: this.onClick,
                mousedown: function mousedown() {
                    return _this.hasMousedown = true;
                },
                mouseup: function mouseup() {
                    return _this.hasMousedown = false;
                }
            })
        }, [getSlot(this, 'default', { open: this.isActive }, true), this.hideActions || this.genIcon()]);
    }
});
//# sourceMappingURL=VExpansionPanelHeader.js.map