var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/styles/components/_selection-controls.sass';
import '../../../src/components/VRadioGroup/VRadioGroup.sass';
// Extensions
import VInput from '../VInput';
import { BaseItemGroup } from '../VItemGroup/VItemGroup';
// Mixins
import Comparable from '../../mixins/comparable';
// Types
import mixins from '../../util/mixins';
var baseMixins = mixins(Comparable, BaseItemGroup, VInput);
/* @vue/component */
export default baseMixins.extend({
    name: 'v-radio-group',
    provide: function provide() {
        return {
            radioGroup: this
        };
    },

    props: {
        column: {
            type: Boolean,
            default: true
        },
        height: {
            type: [Number, String],
            default: 'auto'
        },
        name: String,
        row: Boolean,
        // If no value set on VRadio
        // will match valueComparator
        // force default to null
        value: {
            default: null
        }
    },
    computed: {
        classes: function classes() {
            return _extends({}, VInput.options.computed.classes.call(this), {
                'v-input--selection-controls v-input--radio-group': true,
                'v-input--radio-group--column': this.column && !this.row,
                'v-input--radio-group--row': this.row
            });
        }
    },
    methods: {
        genDefaultSlot: function genDefaultSlot() {
            return this.$createElement('div', {
                staticClass: 'v-input--radio-group__input',
                attrs: {
                    id: this.id,
                    role: 'radiogroup',
                    'aria-labelledby': this.computedId
                }
            }, VInput.options.methods.genDefaultSlot.call(this));
        },
        genInputSlot: function genInputSlot() {
            var render = VInput.options.methods.genInputSlot.call(this);
            delete render.data.on.click;
            return render;
        },
        genLabel: function genLabel() {
            var label = VInput.options.methods.genLabel.call(this);
            if (!label) return null;
            label.data.attrs.id = this.computedId;
            // WAI considers this an orphaned label
            delete label.data.attrs.for;
            label.tag = 'div';
            return label;
        },

        onClick: BaseItemGroup.options.methods.onClick
    }
});
//# sourceMappingURL=VRadioGroup.js.map