'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components

// Helpers


require('../../../src/components/VColorPicker/VColorPicker.sass');

var _VSheet = require('../VSheet/VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _VColorPickerPreview = require('./VColorPickerPreview');

var _VColorPickerPreview2 = _interopRequireDefault(_VColorPickerPreview);

var _VColorPickerCanvas = require('./VColorPickerCanvas');

var _VColorPickerCanvas2 = _interopRequireDefault(_VColorPickerCanvas);

var _VColorPickerEdit = require('./VColorPickerEdit');

var _VColorPickerEdit2 = _interopRequireDefault(_VColorPickerEdit);

var _VColorPickerSwatches = require('./VColorPickerSwatches');

var _VColorPickerSwatches2 = _interopRequireDefault(_VColorPickerSwatches);

var _util = require('./util');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)(_themeable2.default).extend({
    name: 'v-color-picker',
    props: {
        canvasHeight: {
            type: [String, Number],
            default: 150
        },
        disabled: Boolean,
        dotSize: {
            type: [Number, String],
            default: 10
        },
        flat: Boolean,
        hideCanvas: Boolean,
        hideInputs: Boolean,
        hideModeSwitch: Boolean,
        mode: {
            type: String,
            default: 'rgba',
            validator: function validator(v) {
                return Object.keys(_VColorPickerEdit.modes).includes(v);
            }
        },
        showSwatches: Boolean,
        swatches: Array,
        swatchesMaxHeight: {
            type: [Number, String],
            default: 150
        },
        value: {
            type: [Object, String]
        },
        width: {
            type: [Number, String],
            default: 300
        }
    },
    data: function data() {
        return {
            internalValue: (0, _util.fromRGBA)({ r: 255, g: 0, b: 0, a: 1 })
        };
    },
    watch: {
        value: {
            handler: function handler(color) {
                this.updateColor((0, _util.parseColor)(color, this.internalValue));
            },

            immediate: true
        }
    },
    methods: {
        updateColor: function updateColor(color) {
            this.internalValue = color;
            var value = (0, _util.extractColor)(this.internalValue, this.value);
            if (value !== this.value) {
                this.$emit('input', value);
                this.$emit('update:color', this.internalValue);
            }
        },
        genCanvas: function genCanvas() {
            return this.$createElement(_VColorPickerCanvas2.default, {
                props: {
                    color: this.internalValue,
                    disabled: this.disabled,
                    dotSize: this.dotSize,
                    width: this.width,
                    height: this.canvasHeight
                },
                on: {
                    'update:color': this.updateColor
                }
            });
        },
        genControls: function genControls() {
            return this.$createElement('div', {
                staticClass: 'v-color-picker__controls'
            }, [this.genPreview(), !this.hideInputs && this.genEdit()]);
        },
        genEdit: function genEdit() {
            var _this = this;

            return this.$createElement(_VColorPickerEdit2.default, {
                props: {
                    color: this.internalValue,
                    disabled: this.disabled,
                    hideModeSwitch: this.hideModeSwitch,
                    mode: this.mode
                },
                on: {
                    'update:color': this.updateColor,
                    'update:mode': function updateMode(v) {
                        return _this.$emit('update:mode', v);
                    }
                }
            });
        },
        genPreview: function genPreview() {
            return this.$createElement(_VColorPickerPreview2.default, {
                props: {
                    color: this.internalValue,
                    disabled: this.disabled
                },
                on: {
                    'update:color': this.updateColor
                }
            });
        },
        genSwatches: function genSwatches() {
            return this.$createElement(_VColorPickerSwatches2.default, {
                props: {
                    dark: this.dark,
                    light: this.light,
                    swatches: this.swatches,
                    color: this.internalValue,
                    maxHeight: this.swatchesMaxHeight
                },
                on: {
                    'update:color': this.updateColor
                }
            });
        }
    },
    render: function render(h) {
        return h(_VSheet2.default, {
            staticClass: 'v-color-picker',
            class: _extends({
                'v-color-picker--flat': this.flat
            }, this.themeClasses),
            props: {
                maxWidth: this.width
            }
        }, [!this.hideCanvas && this.genCanvas(), this.genControls(), this.showSwatches && this.genSwatches()]);
    }
});
//# sourceMappingURL=VColorPicker.js.map