'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Components

// Utilities


require('../../../src/components/VToolbar/VToolbar.sass');

var _VSheet = require('../VSheet/VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _VImg = require('../VImg/VImg');

var _VImg2 = _interopRequireDefault(_VImg);

var _helpers = require('../../util/helpers');

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = _VSheet2.default.extend({
    name: 'v-toolbar',
    props: {
        absolute: Boolean,
        bottom: Boolean,
        collapse: Boolean,
        dense: Boolean,
        extended: Boolean,
        extensionHeight: {
            default: 48,
            type: [Number, String]
        },
        flat: Boolean,
        floating: Boolean,
        prominent: Boolean,
        short: Boolean,
        src: {
            type: [String, Object],
            default: ''
        },
        tag: {
            type: String,
            default: 'header'
        },
        tile: {
            type: Boolean,
            default: true
        }
    },
    data: function data() {
        return {
            isExtended: false
        };
    },
    computed: {
        computedHeight: function computedHeight() {
            var height = this.computedContentHeight;
            if (!this.isExtended) return height;
            var extensionHeight = parseInt(this.extensionHeight);
            return this.isCollapsed ? height : height + (!isNaN(extensionHeight) ? extensionHeight : 0);
        },
        computedContentHeight: function computedContentHeight() {
            if (this.height) return parseInt(this.height);
            if (this.isProminent && this.dense) return 96;
            if (this.isProminent && this.short) return 112;
            if (this.isProminent) return 128;
            if (this.dense) return 48;
            if (this.short || this.$vuetify.breakpoint.smAndDown) return 56;
            return 64;
        },
        classes: function classes() {
            return _extends({}, _VSheet2.default.options.computed.classes.call(this), {
                'v-toolbar': true,
                'v-toolbar--absolute': this.absolute,
                'v-toolbar--bottom': this.bottom,
                'v-toolbar--collapse': this.collapse,
                'v-toolbar--collapsed': this.isCollapsed,
                'v-toolbar--dense': this.dense,
                'v-toolbar--extended': this.isExtended,
                'v-toolbar--flat': this.flat,
                'v-toolbar--floating': this.floating,
                'v-toolbar--prominent': this.isProminent
            });
        },
        isCollapsed: function isCollapsed() {
            return this.collapse;
        },
        isProminent: function isProminent() {
            return this.prominent;
        },
        styles: function styles() {
            return this.measurableStyles;
        }
    },
    created: function created() {
        var _this = this;

        var breakingProps = [['app', '<v-app-bar app>'], ['manual-scroll', '<v-app-bar :value="false">'], ['clipped-left', '<v-app-bar clipped-left>'], ['clipped-right', '<v-app-bar clipped-right>'], ['inverted-scroll', '<v-app-bar inverted-scroll>'], ['scroll-off-screen', '<v-app-bar scroll-off-screen>'], ['scroll-target', '<v-app-bar scroll-target>'], ['scroll-threshold', '<v-app-bar scroll-threshold>'], ['card', '<v-app-bar flat>']];
        /* istanbul ignore next */
        breakingProps.forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                original = _ref2[0],
                replacement = _ref2[1];

            if (_this.$attrs.hasOwnProperty(original)) (0, _console.breaking)(original, replacement, _this);
        });
    },

    methods: {
        genBackground: function genBackground() {
            var props = {
                height: (0, _helpers.convertToUnit)(this.computedHeight),
                src: this.src
            };
            var image = this.$scopedSlots.img ? this.$scopedSlots.img({ props: props }) : this.$createElement(_VImg2.default, { props: props });
            return this.$createElement('div', {
                staticClass: 'v-toolbar__image'
            }, [image]);
        },
        genContent: function genContent() {
            return this.$createElement('div', {
                staticClass: 'v-toolbar__content',
                style: {
                    height: (0, _helpers.convertToUnit)(this.computedContentHeight)
                }
            }, (0, _helpers.getSlot)(this));
        },
        genExtension: function genExtension() {
            return this.$createElement('div', {
                staticClass: 'v-toolbar__extension',
                style: {
                    height: (0, _helpers.convertToUnit)(this.extensionHeight)
                }
            }, (0, _helpers.getSlot)(this, 'extension'));
        }
    },
    render: function render(h) {
        this.isExtended = this.extended || !!this.$scopedSlots.extension;
        var children = [this.genContent()];
        var data = this.setBackgroundColor(this.color, {
            class: this.classes,
            style: this.styles,
            on: this.$listeners
        });
        if (this.isExtended) children.push(this.genExtension());
        if (this.src || this.$scopedSlots.img) children.unshift(this.genBackground());
        return h(this.tag, data, children);
    }
});
//# sourceMappingURL=VToolbar.js.map