var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VList/VListItemGroup.sass';
// Extensions
import { BaseItemGroup } from '../VItemGroup/VItemGroup';
// Mixins
import Colorable from '../../mixins/colorable';
// Utilities
import mixins from '../../util/mixins';
export default mixins(BaseItemGroup, Colorable).extend({
    name: 'v-list-item-group',
    provide: function provide() {
        return {
            isInGroup: true,
            listItemGroup: this
        };
    },

    computed: {
        classes: function classes() {
            return _extends({}, BaseItemGroup.options.computed.classes.call(this), {
                'v-list-item-group': true
            });
        }
    },
    methods: {
        genData: function genData() {
            return this.setTextColor(this.color, _extends({}, BaseItemGroup.options.methods.genData.call(this), {
                attrs: {
                    role: 'listbox'
                }
            }));
        }
    }
});
//# sourceMappingURL=VListItemGroup.js.map