// Components
import VPicker from '../../components/VPicker';
// Mixins
import Colorable from '../colorable';
import Themeable from '../themeable';
// Utils
import mixins from '../../util/mixins';
export default mixins(Colorable, Themeable
/* @vue/component */
).extend({
    name: 'picker',
    props: {
        fullWidth: Boolean,
        headerColor: String,
        landscape: Boolean,
        noTitle: Boolean,
        width: {
            type: [Number, String],
            default: 290
        }
    },
    methods: {
        genPickerTitle: function genPickerTitle() {
            return null;
        },
        genPickerBody: function genPickerBody() {
            return null;
        },
        genPickerActionsSlot: function genPickerActionsSlot() {
            return this.$scopedSlots.default ? this.$scopedSlots.default({
                save: this.save,
                cancel: this.cancel
            }) : this.$slots.default;
        },
        genPicker: function genPicker(staticClass) {
            var children = [];
            if (!this.noTitle) {
                var title = this.genPickerTitle();
                title && children.push(title);
            }
            var body = this.genPickerBody();
            body && children.push(body);
            children.push(this.$createElement('template', { slot: 'actions' }, [this.genPickerActionsSlot()]));
            return this.$createElement(VPicker, {
                staticClass: staticClass,
                props: {
                    color: this.headerColor || this.color,
                    dark: this.dark,
                    fullWidth: this.fullWidth,
                    landscape: this.landscape,
                    light: this.light,
                    width: this.width,
                    noTitle: this.noTitle
                }
            }, children);
        }
    }
});
//# sourceMappingURL=index.js.map