'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components

// Mixins


require('../../../src/components/VCheckbox/VCheckbox.sass');

require('../../../src/styles/components/_selection-controls.sass');

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VInput = require('../VInput');

var _VInput2 = _interopRequireDefault(_VInput);

var _selectable = require('../../mixins/selectable');

var _selectable2 = _interopRequireDefault(_selectable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = _selectable2.default.extend({
    name: 'v-checkbox',
    props: {
        indeterminate: Boolean,
        indeterminateIcon: {
            type: String,
            default: '$vuetify.icons.checkboxIndeterminate'
        },
        onIcon: {
            type: String,
            default: '$vuetify.icons.checkboxOn'
        },
        offIcon: {
            type: String,
            default: '$vuetify.icons.checkboxOff'
        }
    },
    data: function data() {
        return {
            inputIndeterminate: this.indeterminate
        };
    },

    computed: {
        classes: function classes() {
            return _extends({}, _VInput2.default.options.computed.classes.call(this), {
                'v-input--selection-controls': true,
                'v-input--checkbox': true,
                'v-input--indeterminate': this.inputIndeterminate
            });
        },
        computedIcon: function computedIcon() {
            if (this.inputIndeterminate) {
                return this.indeterminateIcon;
            } else if (this.isActive) {
                return this.onIcon;
            } else {
                return this.offIcon;
            }
        },

        // Do not return undefined if disabled,
        // according to spec, should still show
        // a color when disabled and active
        validationState: function validationState() {
            if (this.disabled && !this.inputIndeterminate) return undefined;
            if (this.hasError && this.shouldValidate) return 'error';
            if (this.hasSuccess) return 'success';
            if (this.hasColor) return this.computedColor;
            return undefined;
        }
    },
    watch: {
        indeterminate: function indeterminate(val) {
            this.inputIndeterminate = val;
        },
        inputIndeterminate: function inputIndeterminate(val) {
            this.$emit('update:indeterminate', val);
        },
        isActive: function isActive() {
            if (!this.indeterminate) return;
            this.inputIndeterminate = false;
        }
    },
    methods: {
        genCheckbox: function genCheckbox() {
            return this.$createElement('div', {
                staticClass: 'v-input--selection-controls__input'
            }, [this.genInput('checkbox', _extends({}, this.$attrs, {
                'aria-checked': this.inputIndeterminate ? 'mixed' : this.isActive.toString()
            })), this.genRipple(this.setTextColor(this.validationState)), this.$createElement(_VIcon2.default, this.setTextColor(this.validationState, {
                props: {
                    dark: this.dark,
                    light: this.light
                }
            }), this.computedIcon)]);
        },
        genDefaultSlot: function genDefaultSlot() {
            return [this.genCheckbox(), this.genLabel()];
        }
    }
});
//# sourceMappingURL=VCheckbox.js.map