'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VCheckbox/VSimpleCheckbox.sass');

var _ripple2 = require('../../directives/ripple');

var _ripple3 = _interopRequireDefault(_ripple2);

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

var _VIcon = require('../VIcon');

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _vue2.default.extend({
    name: 'v-simple-checkbox',
    functional: true,
    directives: {
        ripple: _ripple3.default
    },
    props: _extends({}, _colorable2.default.options.props, _themeable2.default.options.props, {
        disabled: Boolean,
        ripple: {
            type: Boolean,
            default: true
        },
        value: Boolean,
        indeterminate: Boolean,
        indeterminateIcon: {
            type: String,
            default: '$vuetify.icons.checkboxIndeterminate'
        },
        onIcon: {
            type: String,
            default: '$vuetify.icons.checkboxOn'
        },
        offIcon: {
            type: String,
            default: '$vuetify.icons.checkboxOff'
        }
    }),
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data;

        var children = [];
        if (props.ripple && !props.disabled) {
            var _ripple = h('div', _colorable2.default.options.methods.setTextColor(props.color, {
                staticClass: 'v-input--selection-controls__ripple',
                directives: [{
                    name: 'ripple',
                    value: { center: true }
                }]
            }));
            children.push(_ripple);
        }
        var icon = props.offIcon;
        if (props.indeterminate) icon = props.indeterminateIcon;else if (props.value) icon = props.onIcon;
        children.push(h(_VIcon.VIcon, _colorable2.default.options.methods.setTextColor(props.value && props.color, {
            props: {
                disabled: props.disabled,
                dark: props.dark,
                light: props.light
            }
        }), icon));
        var classes = {
            'v-simple-checkbox': true,
            'v-simple-checkbox--disabled': props.disabled
        };
        return h('div', _extends({}, data, {
            class: classes,
            on: {
                click: function click(e) {
                    e.stopPropagation();
                    if (data.on && data.on.input && !props.disabled) {
                        (0, _helpers.wrapInArray)(data.on.input).forEach(function (f) {
                            return f(!props.value);
                        });
                    }
                }
            }
        }), children);
    }
});
//# sourceMappingURL=VSimpleCheckbox.js.map