'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

exports.default = _vue2.default.extend({
    name: 'row-group',
    functional: true,
    props: {
        value: {
            type: Boolean,
            default: true
        },
        headerClass: {
            type: String,
            default: 'v-row-group__header'
        },
        contentClass: String,
        summaryClass: {
            type: String,
            default: 'v-row-group__summary'
        }
    },
    render: function render(h, _ref) {
        var slots = _ref.slots,
            props = _ref.props;

        var computedSlots = slots();
        var children = [];
        if (computedSlots['column.header']) {
            children.push(h('tr', {
                staticClass: props.headerClass
            }, computedSlots['column.header']));
        } else if (computedSlots['row.header']) {
            children.push.apply(children, _toConsumableArray(computedSlots['row.header']));
        }
        if (computedSlots['row.content'] && props.value) children.push.apply(children, _toConsumableArray(computedSlots['row.content']));
        if (computedSlots['column.summary']) {
            children.push(h('tr', {
                staticClass: props.summaryClass
            }, computedSlots['column.summary']));
        } else if (computedSlots['row.summary']) {
            children.push.apply(children, _toConsumableArray(computedSlots['row.summary']));
        }
        return children;
    }
});
//# sourceMappingURL=RowGroup.js.map