'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Mixins


var _registrable = require('../../mixins/registrable');

/* @vue/component */
exports.default = (0, _registrable.provide)('form').extend({
    name: 'v-form',
    inheritAttrs: false,
    props: {
        value: Boolean,
        lazyValidation: Boolean
    },
    data: function data() {
        return {
            inputs: [],
            watchers: [],
            errorBag: {}
        };
    },
    watch: {
        errorBag: {
            handler: function handler(val) {
                var errors = Object.values(val).includes(true);
                this.$emit('input', !errors);
            },

            deep: true,
            immediate: true
        }
    },
    methods: {
        watchInput: function watchInput(input) {
            var _this = this;

            var watcher = function watcher(input) {
                return input.$watch('hasError', function (val) {
                    _this.$set(_this.errorBag, input._uid, val);
                }, { immediate: true });
            };
            var watchers = {
                _uid: input._uid,
                valid: function valid() {},
                shouldValidate: function shouldValidate() {}
            };
            if (this.lazyValidation) {
                // Only start watching inputs if we need to
                watchers.shouldValidate = input.$watch('shouldValidate', function (val) {
                    if (!val) return;
                    // Only watch if we're not already doing it
                    if (_this.errorBag.hasOwnProperty(input._uid)) return;
                    watchers.valid = watcher(input);
                });
            } else {
                watchers.valid = watcher(input);
            }
            return watchers;
        },

        /** @public */
        validate: function validate() {
            return this.inputs.every(function (input) {
                return input.validate(true);
            });
        },

        /** @public */
        reset: function reset() {
            this.inputs.forEach(function (input) {
                return input.reset();
            });
            this.resetErrorBag();
        },
        resetErrorBag: function resetErrorBag() {
            var _this2 = this;

            if (this.lazyValidation) {
                // Account for timeout in validatable
                setTimeout(function () {
                    _this2.errorBag = {};
                }, 0);
            }
        },

        /** @public */
        resetValidation: function resetValidation() {
            this.inputs.forEach(function (input) {
                return input.resetValidation();
            });
            this.resetErrorBag();
        },
        register: function register(input) {
            this.inputs.push(input);
            this.watchers.push(this.watchInput(input));
        },
        unregister: function unregister(input) {
            var found = this.inputs.find(function (i) {
                return i._uid === input._uid;
            });
            if (!found) return;
            var unwatch = this.watchers.find(function (i) {
                return i._uid === found._uid;
            });
            if (unwatch) {
                unwatch.valid();
                unwatch.shouldValidate();
            }
            this.watchers = this.watchers.filter(function (i) {
                return i._uid !== found._uid;
            });
            this.inputs = this.inputs.filter(function (i) {
                return i._uid !== found._uid;
            });
            this.$delete(this.errorBag, found._uid);
        }
    },
    render: function render(h) {
        var _this3 = this;

        return h('form', {
            staticClass: 'v-form',
            attrs: _extends({
                novalidate: true
            }, this.$attrs),
            on: {
                submit: function submit(e) {
                    return _this3.$emit('submit', e);
                }
            }
        }, this.$slots.default);
    }
});
//# sourceMappingURL=VForm.js.map