'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VGrid/VGrid.sass');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

var _mergeData = require('../../util/mergeData');

var _mergeData2 = _interopRequireDefault(_mergeData);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// no xs
var breakpoints = ['sm', 'md', 'lg', 'xl'];
var breakpointProps = function () {
    return breakpoints.reduce(function (props, val) {
        props[val] = {
            type: [Boolean, String, Number],
            default: false
        };
        return props;
    }, {});
}();
var offsetProps = function () {
    return breakpoints.reduce(function (props, val) {
        props['offset' + (0, _helpers.upperFirst)(val)] = {
            type: [String, Number],
            default: null
        };
        return props;
    }, {});
}();
var orderProps = function () {
    return breakpoints.reduce(function (props, val) {
        props['order' + (0, _helpers.upperFirst)(val)] = {
            type: [String, Number],
            default: null
        };
        return props;
    }, {});
}();
var propMap = {
    col: Object.keys(breakpointProps),
    offset: Object.keys(offsetProps),
    order: Object.keys(orderProps)
};
function breakpointClass(type, prop, val) {
    var className = type;
    if (val == null || val === false) {
        return undefined;
    }
    if (prop) {
        var breakpoint = prop.replace(type, '');
        className += '-' + breakpoint;
    }
    // Handling the boolean style prop when accepting [Boolean, String, Number]
    // means Vue will not convert <v-col sm></v-col> to sm: true for us.
    // Since the default is false, an empty string indicates the prop's presence.
    if (type === 'col' && (val === '' || val === true)) {
        // .col-md
        return className.toLowerCase();
    }
    // .order-md-6
    className += '-' + val;
    return className.toLowerCase();
}
var cache = new Map();
exports.default = _vue2.default.extend({
    name: 'v-col',
    functional: true,
    props: _extends({
        cols: {
            type: [Boolean, String, Number],
            default: false
        }
    }, breakpointProps, {
        offset: {
            type: [String, Number],
            default: null
        }
    }, offsetProps, {
        order: {
            type: [String, Number],
            default: null
        }
    }, orderProps, {
        alignSelf: {
            type: String,
            default: null,
            validator: function validator(str) {
                return ['auto', 'start', 'end', 'center', 'baseline', 'stretch'].includes(str);
            }
        },
        tag: {
            type: String,
            default: 'div'
        }
    }),
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            children = _ref.children,
            parent = _ref.parent;

        // Super-fast memoization based on props, 5x faster than JSON.stringify
        var cacheKey = '';
        for (var prop in props) {
            cacheKey += String(props[prop]);
        }
        var classList = cache.get(cacheKey);
        if (!classList) {
            (function () {
                var _classList$push;

                classList = [];
                // Loop through `col`, `offset`, `order` breakpoint props
                var type = void 0;
                for (type in propMap) {
                    propMap[type].forEach(function (prop) {
                        var value = props[prop];
                        var className = breakpointClass(type, prop, value);
                        if (className) classList.push(className);
                    });
                }
                var hasColClasses = classList.some(function (className) {
                    return className.startsWith('col-');
                });
                classList.push((_classList$push = {
                    // Default to .col if no other col-{bp}-* classes generated nor `cols` specified.
                    col: !hasColClasses || !props.cols
                }, _defineProperty(_classList$push, 'col-' + props.cols, props.cols), _defineProperty(_classList$push, 'offset-' + props.offset, props.offset), _defineProperty(_classList$push, 'order-' + props.order, props.order), _defineProperty(_classList$push, 'align-self-' + props.alignSelf, props.alignSelf), _classList$push));
                cache.set(cacheKey, classList);
            })();
        }
        return h(props.tag, (0, _mergeData2.default)(data, { class: classList }), children);
    }
});
//# sourceMappingURL=VCol.js.map