'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VGrid/VGrid.sass');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

var _mergeData = require('../../util/mergeData');

var _mergeData2 = _interopRequireDefault(_mergeData);

var _helpers = require('../../util/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// no xs
var breakpoints = ['sm', 'md', 'lg', 'xl'];
var ALIGNMENT = ['start', 'end', 'center'];
function makeProps(prefix, def) {
    return breakpoints.reduce(function (props, val) {
        props[prefix + (0, _helpers.upperFirst)(val)] = def();
        return props;
    }, {});
}
var alignValidator = function alignValidator(str) {
    return [].concat(ALIGNMENT, ['baseline', 'stretch']).includes(str);
};
var alignProps = makeProps('align', function () {
    return {
        type: String,
        default: null,
        validator: alignValidator
    };
});
var justifyValidator = function justifyValidator(str) {
    return [].concat(ALIGNMENT, ['space-between', 'space-around']).includes(str);
};
var justifyProps = makeProps('justify', function () {
    return {
        type: String,
        default: null,
        validator: justifyValidator
    };
});
var alignContentValidator = function alignContentValidator(str) {
    return [].concat(ALIGNMENT, ['space-between', 'space-around', 'stretch']).includes(str);
};
var alignContentProps = makeProps('alignContent', function () {
    return {
        type: String,
        default: null,
        validator: alignContentValidator
    };
});
var propMap = {
    align: Object.keys(alignProps),
    justify: Object.keys(justifyProps),
    alignContent: Object.keys(alignContentProps)
};
var classMap = {
    align: 'align',
    justify: 'justify',
    alignContent: 'align-content'
};
function breakpointClass(type, prop, val) {
    var className = classMap[type];
    if (val == null) {
        return undefined;
    }
    if (prop) {
        // alignSm -> Sm
        var breakpoint = prop.replace(type, '');
        className += '-' + breakpoint;
    }
    // .align-items-sm-center
    className += '-' + val;
    return className.toLowerCase();
}
var cache = new Map();
exports.default = _vue2.default.extend({
    name: 'v-row',
    functional: true,
    props: _extends({
        tag: {
            type: String,
            default: 'div'
        },
        dense: Boolean,
        noGutters: Boolean,
        align: {
            type: String,
            default: null,
            validator: alignValidator
        }
    }, alignProps, {
        justify: {
            type: String,
            default: null,
            validator: justifyValidator
        }
    }, justifyProps, {
        alignContent: {
            type: String,
            default: null,
            validator: alignContentValidator
        }
    }, alignContentProps),
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            children = _ref.children;

        // Super-fast memoization based on props, 5x faster than JSON.stringify
        var cacheKey = '';
        for (var prop in props) {
            cacheKey += String(props[prop]);
        }
        var classList = cache.get(cacheKey);
        if (!classList) {
            (function () {
                var _classList$push;

                classList = [];
                // Loop through `align`, `justify`, `alignContent` breakpoint props
                var type = void 0;
                for (type in propMap) {
                    propMap[type].forEach(function (prop) {
                        var value = props[prop];
                        var className = breakpointClass(type, prop, value);
                        if (className) classList.push(className);
                    });
                }
                classList.push((_classList$push = {
                    'no-gutters': props.noGutters
                }, _defineProperty(_classList$push, 'align-' + props.align, props.align), _defineProperty(_classList$push, 'justify-' + props.justify, props.justify), _defineProperty(_classList$push, 'align-content-' + props.alignContent, props.alignContent), _classList$push));
                cache.set(cacheKey, classList);
            })();
        }
        return h(props.tag, (0, _mergeData2.default)(data, {
            staticClass: props.dense ? 'form-row' : 'row',
            class: classList
        }), children);
    }
});
//# sourceMappingURL=VRow.js.map