'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _registrable = require('../../mixins/registrable');

var _ripple = require('../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Directives

// Mixins
var baseMixins = (0, _mixins2.default)(_colorable2.default, (0, _registrable.inject)('stepper', 'v-stepper-step', 'v-stepper'));
/* @vue/component */

// Utilities
// Components
exports.default = baseMixins.extend().extend({
    name: 'v-stepper-step',
    directives: { ripple: _ripple2.default },
    inject: ['stepClick'],
    props: {
        color: {
            type: String,
            default: 'primary'
        },
        complete: Boolean,
        completeIcon: {
            type: String,
            default: '$vuetify.icons.complete'
        },
        editIcon: {
            type: String,
            default: '$vuetify.icons.edit'
        },
        errorIcon: {
            type: String,
            default: '$vuetify.icons.error'
        },
        editable: Boolean,
        rules: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        step: [Number, String]
    },
    data: function data() {
        return {
            isActive: false,
            isInactive: true
        };
    },

    computed: {
        classes: function classes() {
            return {
                'v-stepper__step--active': this.isActive,
                'v-stepper__step--editable': this.editable,
                'v-stepper__step--inactive': this.isInactive,
                'v-stepper__step--error error--text': this.hasError,
                'v-stepper__step--complete': this.complete
            };
        },
        hasError: function hasError() {
            return this.rules.some(function (validate) {
                return validate() !== true;
            });
        }
    },
    mounted: function mounted() {
        this.stepper && this.stepper.register(this);
    },
    beforeDestroy: function beforeDestroy() {
        this.stepper && this.stepper.unregister(this);
    },

    methods: {
        click: function click(e) {
            e.stopPropagation();
            this.$emit('click', e);
            if (this.editable) {
                this.stepClick(this.step);
            }
        },
        genIcon: function genIcon(icon) {
            return this.$createElement(_VIcon2.default, icon);
        },
        genLabel: function genLabel() {
            return this.$createElement('div', {
                staticClass: 'v-stepper__label'
            }, this.$slots.default);
        },
        genStep: function genStep() {
            var color = !this.hasError && (this.complete || this.isActive) ? this.color : false;
            return this.$createElement('span', this.setBackgroundColor(color, {
                staticClass: 'v-stepper__step__step'
            }), this.genStepContent());
        },
        genStepContent: function genStepContent() {
            var children = [];
            if (this.hasError) {
                children.push(this.genIcon(this.errorIcon));
            } else if (this.complete) {
                if (this.editable) {
                    children.push(this.genIcon(this.editIcon));
                } else {
                    children.push(this.genIcon(this.completeIcon));
                }
            } else {
                children.push(String(this.step));
            }
            return children;
        },
        toggle: function toggle(step) {
            this.isActive = step.toString() === this.step.toString();
            this.isInactive = Number(step) < Number(this.step);
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-stepper__step',
            class: this.classes,
            directives: [{
                name: 'ripple',
                value: this.editable
            }],
            on: { click: this.click }
        }, [this.genStep(), this.genLabel()]);
    }
});
//# sourceMappingURL=VStepperStep.js.map