'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Extensions

// Types & Components


var _VWindow = require('../VWindow/VWindow');

var _VWindow2 = _interopRequireDefault(_VWindow);

var _VItemGroup = require('./../VItemGroup/VItemGroup');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = _VWindow2.default.extend({
    name: 'v-tabs-items',
    props: {
        mandatory: {
            type: Boolean,
            default: false
        }
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VWindow2.default.options.computed.classes.call(this), {
                'v-tabs-items': true
            });
        },
        isDark: function isDark() {
            return this.rootIsDark;
        }
    },
    methods: {
        getValue: function getValue(item, i) {
            return item.id || _VItemGroup.BaseItemGroup.options.methods.getValue.call(this, item, i);
        }
    }
});
//# sourceMappingURL=VTabsItems.js.map