'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.functionalThemeClasses = functionalThemeClasses;

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function functionalThemeClasses(context) {
    var vm = _extends({}, context.props, context.injections);
    var isDark = Themeable.options.computed.isDark.call(vm);
    return Themeable.options.computed.themeClasses.call({ isDark: isDark });
}
/* @vue/component */
var Themeable = _vue2.default.extend().extend({
    name: 'themeable',
    provide: function provide() {
        return {
            theme: this.themeableProvide
        };
    },

    inject: {
        theme: {
            default: {
                isDark: false
            }
        }
    },
    props: {
        dark: {
            type: Boolean,
            default: null
        },
        light: {
            type: Boolean,
            default: null
        }
    },
    data: function data() {
        return {
            themeableProvide: {
                isDark: false
            }
        };
    },

    computed: {
        appIsDark: function appIsDark() {
            return this.$vuetify.theme.dark || false;
        },
        isDark: function isDark() {
            if (this.dark === true) {
                // explicitly dark
                return true;
            } else if (this.light === true) {
                // explicitly light
                return false;
            } else {
                // inherit from parent, or default false if there is none
                return this.theme.isDark;
            }
        },
        themeClasses: function themeClasses() {
            return {
                'theme--dark': this.isDark,
                'theme--light': !this.isDark
            };
        },

        /** Used by menus and dialogs, inherits from v-app instead of the parent */
        rootIsDark: function rootIsDark() {
            if (this.dark === true) {
                // explicitly dark
                return true;
            } else if (this.light === true) {
                // explicitly light
                return false;
            } else {
                // inherit from v-app
                return this.appIsDark;
            }
        },
        rootThemeClasses: function rootThemeClasses() {
            return {
                'theme--dark': this.rootIsDark,
                'theme--light': !this.rootIsDark
            };
        }
    },
    watch: {
        isDark: {
            handler: function handler(newVal, oldVal) {
                if (newVal !== oldVal) {
                    this.themeableProvide.isDark = this.isDark;
                }
            },

            immediate: true
        }
    }
});
exports.default = Themeable;
//# sourceMappingURL=index.js.map