'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = mergeData;
/**
 * @copyright 2017 Alex Regan
 * @license MIT
 * @see https://github.com/alexsasharegan/vue-functional-data-merge
 */
function mergeData() {
    var mergeTarget = {};
    var i = arguments.length;
    var prop = void 0;
    var event = void 0;
    // Allow for variadic argument length.
    while (i--) {
        // Iterate through the data properties and execute merge strategies
        // Object.keys eliminates need for hasOwnProperty call
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
            for (var _iterator = Object.keys(arguments[i])[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                prop = _step.value;

                switch (prop) {
                    // Array merge strategy (array concatenation)
                    case 'class':
                    case 'style':
                    case 'directives':
                        if (!Array.isArray(mergeTarget[prop])) {
                            mergeTarget[prop] = [];
                        }
                        // Repackaging in an array allows Vue runtime
                        // to merge class/style bindings regardless of type.
                        mergeTarget[prop] = mergeTarget[prop].concat(arguments[i][prop]);
                        break;
                    // Space delimited string concatenation strategy
                    case 'staticClass':
                        if (!arguments[i][prop]) {
                            break;
                        }
                        if (mergeTarget[prop] === undefined) {
                            mergeTarget[prop] = '';
                        }
                        if (mergeTarget[prop]) {
                            // Not an empty string, so concatenate
                            mergeTarget[prop] += ' ';
                        }
                        mergeTarget[prop] += arguments[i][prop].trim();
                        break;
                    // Object, the properties of which to merge via array merge strategy (array concatenation).
                    // Callback merge strategy merges callbacks to the beginning of the array,
                    // so that the last defined callback will be invoked first.
                    // This is done since to mimic how Object.assign merging
                    // uses the last given value to assign.
                    case 'on':
                    case 'nativeOn':
                        if (!mergeTarget[prop]) {
                            mergeTarget[prop] = {};
                        }
                        var listeners = mergeTarget[prop];
                        var _iteratorNormalCompletion2 = true;
                        var _didIteratorError2 = false;
                        var _iteratorError2 = undefined;

                        try {
                            for (var _iterator2 = Object.keys(arguments[i][prop] || {})[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                                event = _step2.value;

                                // Concat function to array of functions if callback present.
                                if (listeners[event]) {
                                    // Insert current iteration data in beginning of merged array.
                                    listeners[event] = Array().concat( // eslint-disable-line
                                    listeners[event], arguments[i][prop][event]);
                                } else {
                                    // Straight assign.
                                    listeners[event] = arguments[i][prop][event];
                                }
                            }
                        } catch (err) {
                            _didIteratorError2 = true;
                            _iteratorError2 = err;
                        } finally {
                            try {
                                if (!_iteratorNormalCompletion2 && _iterator2.return) {
                                    _iterator2.return();
                                }
                            } finally {
                                if (_didIteratorError2) {
                                    throw _iteratorError2;
                                }
                            }
                        }

                        break;
                    // Object merge strategy
                    case 'attrs':
                    case 'props':
                    case 'domProps':
                    case 'scopedSlots':
                    case 'staticStyle':
                    case 'hook':
                    case 'transition':
                        if (!mergeTarget[prop]) {
                            mergeTarget[prop] = {};
                        }
                        mergeTarget[prop] = _extends({}, arguments[i][prop], mergeTarget[prop]);
                        break;
                    // Reassignment strategy (no merge)
                    case 'slot':
                    case 'key':
                    case 'ref':
                    case 'tag':
                    case 'show':
                    case 'keepAlive':
                    default:
                        if (!mergeTarget[prop]) {
                            mergeTarget[prop] = arguments[i][prop];
                        }
                }
            }
        } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
        } finally {
            try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                    _iterator.return();
                }
            } finally {
                if (_didIteratorError) {
                    throw _iteratorError;
                }
            }
        }
    }
    return mergeTarget;
}
//# sourceMappingURL=mergeData.js.map