var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// Styles
import '../../../src/components/VFileInput/VFileInput.sass';
// Extensions
import VTextField from '../VTextField';
// Components
import { VChip } from '../VChip';
// Utilities
import { humanReadableFileSize, wrapInArray } from '../../util/helpers';
export default VTextField.extend({
    name: 'v-file-input',
    model: {
        prop: 'value',
        event: 'change'
    },
    props: {
        chips: Boolean,
        clearable: {
            type: Boolean,
            default: true
        },
        counterSizeString: {
            type: String,
            default: '$vuetify.fileInput.counterSize'
        },
        counterString: {
            type: String,
            default: '$vuetify.fileInput.counter'
        },
        placeholder: String,
        prependIcon: {
            type: String,
            default: '$vuetify.icons.file'
        },
        readonly: {
            type: Boolean,
            default: true
        },
        showSize: {
            type: [Boolean, Number],
            default: false,
            validator: function validator(v) {
                return typeof v === 'boolean' || [1000, 1024].includes(v);
            }
        },
        smallChips: Boolean,
        truncateLength: {
            type: [Number, String],
            default: 22
        },
        type: {
            type: String,
            default: 'file'
        },
        value: {
            default: function _default() {
                return [];
            },
            validator: function validator(val) {
                return (typeof val === 'undefined' ? 'undefined' : _typeof(val)) === 'object' || Array.isArray(val);
            }
        }
    },
    data: function data() {
        return {
            internalFileInput: null
        };
    },
    computed: {
        classes: function classes() {
            return _extends({}, VTextField.options.computed.classes.call(this), {
                'v-file-input': true
            });
        },
        counterValue: function counterValue() {
            if (!this.showSize) return this.$vuetify.lang.t(this.counterString, this.lazyValue.length);
            var bytes = this.internalArrayValue.reduce(function (size, file) {
                return size + file.size;
            }, 0);
            return this.$vuetify.lang.t(this.counterSizeString, this.lazyValue.length, humanReadableFileSize(bytes, this.base === 1024));
        },
        internalArrayValue: function internalArrayValue() {
            return Array.isArray(this.internalValue) ? this.internalValue : wrapInArray(this.internalValue);
        },

        internalValue: {
            get: function get() {
                return this.lazyValue;
            },
            set: function set(val) {
                this.lazyValue = val;
                this.$emit('change', this.lazyValue);
            }
        },
        isDirty: function isDirty() {
            return this.internalArrayValue.length > 0;
        },
        isLabelActive: function isLabelActive() {
            return this.isDirty;
        },
        isMultiple: function isMultiple() {
            return this.$attrs.hasOwnProperty('multiple');
        },
        text: function text() {
            var _this = this;

            if (!this.isDirty) return [this.placeholder];
            return this.internalArrayValue.map(function (file) {
                var name = _this.truncateText(file.name);
                return !_this.showSize ? name : name + ' (' + humanReadableFileSize(file.size, _this.base === 1024) + ')';
            });
        },
        base: function base() {
            return typeof this.showSize !== 'boolean' ? this.showSize : undefined;
        },
        hasChips: function hasChips() {
            return this.chips || this.smallChips;
        }
    },
    methods: {
        clearableCallback: function clearableCallback() {
            this.internalValue = this.isMultiple ? [] : null;
            this.internalFileInput = null;
        },
        genChips: function genChips() {
            var _this2 = this;

            if (!this.isDirty) return [];
            return this.text.map(function (text, index) {
                return _this2.$createElement(VChip, {
                    props: { small: _this2.smallChips },
                    on: {
                        'click:close': function clickClose() {
                            var internalValue = _this2.internalValue;
                            internalValue.splice(index, 1);
                            _this2.internalValue = internalValue; // Trigger the watcher
                        }
                    }
                }, [text]);
            });
        },
        genInput: function genInput() {
            var input = VTextField.options.methods.genInput.call(this);
            input.data.domProps.value = this.internalFileInput;
            return [this.genSelections(), input];
        },
        genPrependSlot: function genPrependSlot() {
            var _this3 = this;

            var icon = this.genIcon('prepend', function () {
                _this3.$refs.input.click();
            });
            icon.data.attrs = { tabindex: 0 };
            return this.genSlot('prepend', 'outer', [icon]);
        },
        genSelectionText: function genSelectionText() {
            var length = this.text.length;
            if (length < 2) return this.text;
            if (this.showSize && !this.counter) return [this.counterValue];
            return [this.$vuetify.lang.t(this.counterString, length)];
        },
        genSelections: function genSelections() {
            var _this4 = this;

            var children = [];
            if (this.isDirty && this.$scopedSlots.selection) {
                this.internalValue.forEach(function (file, index) {
                    if (!_this4.$scopedSlots.selection) return;
                    children.push(_this4.$scopedSlots.selection({
                        text: _this4.text[index],
                        file: file,
                        index: index
                    }));
                });
            } else {
                children.push(this.hasChips && this.isDirty ? this.genChips() : this.genSelectionText());
            }
            return this.$createElement('div', {
                staticClass: 'v-file-input__text',
                class: {
                    'v-file-input__text--placeholder': this.placeholder && !this.isDirty,
                    'v-file-input__text--chips': this.hasChips && !this.$scopedSlots.selection
                },
                on: {
                    click: function click() {
                        return _this4.$refs.input.click();
                    }
                }
            }, children);
        },
        onInput: function onInput(e) {
            var files = [].concat(_toConsumableArray(e.target.files));
            this.internalValue = this.isMultiple ? files : files[0];
        },
        truncateText: function truncateText(str) {
            if (str.length < Number(this.truncateLength)) return str;
            return str.slice(0, 10) + '\u2026' + str.slice(-10);
        }
    }
});
//# sourceMappingURL=VFileInput.js.map