var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VTabs/VTabs.sass';
// Components
import VTabsBar from './VTabsBar';
import VTabsItems from './VTabsItems';
import VTabsSlider from './VTabsSlider';
// Mixins
import Colorable from '../../mixins/colorable';
import Proxyable from '../../mixins/proxyable';
import Themeable from '../../mixins/themeable';
// Directives
import Resize from '../../directives/resize';
// Utilities
import { convertToUnit } from '../../util/helpers';
import mixins from '../../util/mixins';
var baseMixins = mixins(Colorable, Proxyable, Themeable);
export default baseMixins.extend().extend({
    name: 'v-tabs',
    directives: {
        Resize: Resize
    },
    props: {
        activeClass: {
            type: String,
            default: ''
        },
        alignWithTitle: Boolean,
        backgroundColor: String,
        centered: Boolean,
        centerActive: Boolean,
        fixedTabs: Boolean,
        grow: Boolean,
        height: {
            type: [Number, String],
            default: undefined
        },
        hideSlider: Boolean,
        iconsAndText: Boolean,
        mobileBreakPoint: {
            type: [Number, String],
            default: 1264
        },
        nextIcon: {
            type: String,
            default: '$vuetify.icons.next'
        },
        optional: Boolean,
        prevIcon: {
            type: String,
            default: '$vuetify.icons.prev'
        },
        right: Boolean,
        showArrows: Boolean,
        sliderColor: String,
        vertical: Boolean
    },
    data: function data() {
        return {
            resizeTimeout: 0,
            slider: {
                height: null,
                left: null,
                right: null,
                top: null,
                width: null
            },
            transitionTime: 300
        };
    },

    computed: {
        classes: function classes() {
            return _extends({
                'v-tabs--align-with-title': this.alignWithTitle,
                'v-tabs--centered': this.centered,
                'v-tabs--fixed-tabs': this.fixedTabs,
                'v-tabs--grow': this.grow,
                'v-tabs--icons-and-text': this.iconsAndText,
                'v-tabs--right': this.right,
                'v-tabs--vertical': this.vertical
            }, this.themeClasses);
        },
        isReversed: function isReversed() {
            return this.$vuetify.rtl && this.vertical;
        },
        sliderStyles: function sliderStyles() {
            return {
                height: convertToUnit(this.slider.height),
                left: this.isReversed ? undefined : convertToUnit(this.slider.left),
                right: this.isReversed ? convertToUnit(this.slider.right) : undefined,
                top: this.vertical ? convertToUnit(this.slider.top) : undefined,
                transition: this.slider.left != null ? null : 'none',
                width: convertToUnit(this.slider.width)
            };
        },
        computedColor: function computedColor() {
            if (this.color) return this.color;else if (this.isDark && !this.appIsDark) return 'white';else return 'primary';
        }
    },
    watch: {
        alignWithTitle: 'callSlider',
        centered: 'callSlider',
        centerActive: 'callSlider',
        fixedTabs: 'callSlider',
        grow: 'callSlider',
        right: 'callSlider',
        showArrows: 'callSlider',
        vertical: 'callSlider',
        '$vuetify.application.left': 'onResize',
        '$vuetify.application.right': 'onResize',
        '$vuetify.rtl': 'onResize'
    },
    mounted: function mounted() {
        var _this = this;

        this.$nextTick(function () {
            window.setTimeout(_this.callSlider, 30);
        });
    },

    methods: {
        callSlider: function callSlider() {
            var _this2 = this;

            if (this.hideSlider || !this.$refs.items || !this.$refs.items.selectedItems.length) {
                this.slider.width = 0;
                return false;
            }
            this.$nextTick(function () {
                // Give screen time to paint
                var activeTab = _this2.$refs.items.selectedItems[0];
                /* istanbul ignore if */
                if (!activeTab || !activeTab.$el) {
                    _this2.slider.width = 0;
                    _this2.slider.left = 0;
                    return;
                }
                var el = activeTab.$el;
                _this2.slider = {
                    height: _this2.vertical ? el.offsetHeight : 2,
                    left: _this2.vertical ? 0 : el.offsetLeft,
                    right: _this2.vertical ? 0 : el.offsetLeft + el.offsetWidth,
                    top: el.offsetTop,
                    width: _this2.vertical ? 2 : el.scrollWidth
                };
            });
            return true;
        },
        genBar: function genBar(items, slider) {
            var _this3 = this;

            var data = {
                staticClass: this.backgroundColor,
                style: {
                    height: convertToUnit(this.height)
                },
                props: {
                    activeClass: this.activeClass,
                    centerActive: this.centerActive,
                    dark: this.dark,
                    light: this.light,
                    mandatory: !this.optional,
                    mobileBreakPoint: this.mobileBreakPoint,
                    nextIcon: this.nextIcon,
                    prevIcon: this.prevIcon,
                    showArrows: this.showArrows,
                    value: this.internalValue
                },
                on: {
                    'call:slider': this.callSlider,
                    change: function change(val) {
                        _this3.internalValue = val;
                    }
                },
                ref: 'items'
            };
            this.setTextColor(this.computedColor, data);
            this.setBackgroundColor(this.backgroundColor, data);
            return this.$createElement(VTabsBar, data, [this.genSlider(slider), items]);
        },
        genItems: function genItems(items, item) {
            var _this4 = this;

            // If user provides items
            // opt to use theirs
            if (items) return items;
            // If no tabs are provided
            // render nothing
            if (!item.length) return null;
            return this.$createElement(VTabsItems, {
                props: {
                    value: this.internalValue
                },
                on: {
                    change: function change(val) {
                        _this4.internalValue = val;
                    }
                }
            }, item);
        },
        genSlider: function genSlider(slider) {
            if (this.hideSlider) return null;
            if (!slider) {
                slider = this.$createElement(VTabsSlider, {
                    props: { color: this.sliderColor }
                });
            }
            return this.$createElement('div', {
                staticClass: 'v-tabs-slider-wrapper',
                style: this.sliderStyles
            }, [slider]);
        },
        onResize: function onResize() {
            if (this._isDestroyed) return;
            clearTimeout(this.resizeTimeout);
            this.resizeTimeout = window.setTimeout(this.callSlider, 0);
        },
        parseNodes: function parseNodes() {
            var items = null;
            var slider = null;
            var item = [];
            var tab = [];
            var slot = this.$slots.default || [];
            var length = slot.length;
            for (var i = 0; i < length; i++) {
                var vnode = slot[i];
                if (vnode.componentOptions) {
                    switch (vnode.componentOptions.Ctor.options.name) {
                        case 'v-tabs-slider':
                            slider = vnode;
                            break;
                        case 'v-tabs-items':
                            items = vnode;
                            break;
                        case 'v-tab-item':
                            item.push(vnode);
                            break;
                        // case 'v-tab' - intentionally omitted
                        default:
                            tab.push(vnode);
                    }
                } else {
                    tab.push(vnode);
                }
            }
            /**
             * tab: array of `v-tab`
             * slider: single `v-tabs-slider`
             * items: single `v-tabs-items`
             * item: array of `v-tab-item`
             */
            return { tab: tab, slider: slider, items: items, item: item };
        }
    },
    render: function render(h) {
        var _parseNodes = this.parseNodes(),
            tab = _parseNodes.tab,
            slider = _parseNodes.slider,
            items = _parseNodes.items,
            item = _parseNodes.item;

        return h('div', {
            staticClass: 'v-tabs',
            class: this.classes,
            directives: [{
                name: 'resize',
                modifiers: { quiet: true },
                value: this.onResize
            }]
        }, [this.genBar(tab, slider), this.genItems(items, item)]);
    }
});
//# sourceMappingURL=VTabs.js.map