// Components
import VInput from '../../components/VInput';
// Mixins
import Rippleable from '../rippleable';
import Comparable from '../comparable';
// Utilities
import mixins from '../../util/mixins';
/* @vue/component */
export default mixins(VInput, Rippleable, Comparable).extend({
    name: 'selectable',
    model: {
        prop: 'inputValue',
        event: 'change'
    },
    props: {
        id: String,
        inputValue: null,
        falseValue: null,
        trueValue: null,
        multiple: {
            type: Boolean,
            default: null
        },
        label: String
    },
    data: function data() {
        return {
            hasColor: this.inputValue,
            lazyValue: this.inputValue
        };
    },

    computed: {
        computedColor: function computedColor() {
            if (!this.isActive) return undefined;
            if (this.color) return this.color;
            if (this.isDark && !this.appIsDark) return 'white';
            return 'accent';
        },
        isMultiple: function isMultiple() {
            return this.multiple === true || this.multiple === null && Array.isArray(this.internalValue);
        },
        isActive: function isActive() {
            var _this = this;

            var value = this.value;
            var input = this.internalValue;
            if (this.isMultiple) {
                if (!Array.isArray(input)) return false;
                return input.some(function (item) {
                    return _this.valueComparator(item, value);
                });
            }
            if (this.trueValue === undefined || this.falseValue === undefined) {
                return value ? this.valueComparator(value, input) : Boolean(input);
            }
            return this.valueComparator(input, this.trueValue);
        },
        isDirty: function isDirty() {
            return this.isActive;
        }
    },
    watch: {
        inputValue: function inputValue(val) {
            this.lazyValue = val;
            this.hasColor = val;
        }
    },
    methods: {
        genLabel: function genLabel() {
            var _this2 = this;

            var label = VInput.options.methods.genLabel.call(this);
            if (!label) return label;
            label.data.on = {
                click: function click(e) {
                    // Prevent label from
                    // causing the input
                    // to focus
                    e.preventDefault();
                    _this2.onChange();
                }
            };
            return label;
        },
        genInput: function genInput(type, attrs) {
            return this.$createElement('input', {
                attrs: Object.assign({
                    'aria-checked': this.isActive.toString(),
                    disabled: this.isDisabled,
                    id: this.computedId,
                    role: type,
                    type: type
                }, attrs),
                domProps: {
                    value: this.value,
                    checked: this.isActive
                },
                on: {
                    blur: this.onBlur,
                    change: this.onChange,
                    focus: this.onFocus,
                    keydown: this.onKeydown
                },
                ref: 'input'
            });
        },
        onBlur: function onBlur() {
            this.isFocused = false;
        },
        onChange: function onChange() {
            var _this3 = this;

            if (this.isDisabled) return;
            var value = this.value;
            var input = this.internalValue;
            if (this.isMultiple) {
                if (!Array.isArray(input)) {
                    input = [];
                }
                var length = input.length;
                input = input.filter(function (item) {
                    return !_this3.valueComparator(item, value);
                });
                if (input.length === length) {
                    input.push(value);
                }
            } else if (this.trueValue !== undefined && this.falseValue !== undefined) {
                input = this.valueComparator(input, this.trueValue) ? this.falseValue : this.trueValue;
            } else if (value) {
                input = this.valueComparator(input, value) ? null : value;
            } else {
                input = !input;
            }
            this.validate(true, input);
            this.internalValue = input;
            this.hasColor = input;
        },
        onFocus: function onFocus() {
            this.isFocused = true;
        },

        /** @abstract */
        onKeydown: function onKeydown(e) {}
    }
});
//# sourceMappingURL=index.js.map