"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VAvatar/VAvatar.sass");

var _colorable = _interopRequireDefault(require("../../mixins/colorable"));

var _measurable = _interopRequireDefault(require("../../mixins/measurable"));

var _roundable = _interopRequireDefault(require("../../mixins/roundable"));

var _helpers = require("../../util/helpers");

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = (0, _mixins.default)(_colorable.default, _measurable.default, _roundable.default).extend({
  name: 'v-avatar',
  props: {
    left: Boolean,
    right: Boolean,
    size: {
      type: [Number, String],
      default: 48
    }
  },
  computed: {
    classes: function classes() {
      return _objectSpread({
        'v-avatar--left': this.left,
        'v-avatar--right': this.right
      }, this.roundedClasses);
    },
    styles: function styles() {
      return _objectSpread({
        height: (0, _helpers.convertToUnit)(this.size),
        minWidth: (0, _helpers.convertToUnit)(this.size),
        width: (0, _helpers.convertToUnit)(this.size)
      }, this.measurableStyles);
    }
  },
  render: function render(h) {
    var data = {
      staticClass: 'v-avatar',
      class: this.classes,
      style: this.styles,
      on: this.$listeners
    };
    return h('div', this.setBackgroundColor(this.color, data), this.$slots.default);
  }
});

exports.default = _default;
//# sourceMappingURL=VAvatar.js.map