"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parsedCategoryText = parsedCategoryText;
exports.getParsedCategories = getParsedCategories;

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function parsedCategoryText(category, categoryText) {
  return typeof categoryText === 'string' && _typeof(category) === 'object' && category ? category[categoryText] : typeof categoryText === 'function' ? categoryText(category) : category;
}

function getParsedCategories(categories, categoryText) {
  if (typeof categories === 'string') return categories.split(/\s*,\s/);

  if (Array.isArray(categories)) {
    return categories.map(function (v) {
      var categoryName = typeof v === 'string' ? v : _typeof(v) === 'object' && v && typeof v.categoryName === 'string' ? v.categoryName : parsedCategoryText(v, categoryText);
      return {
        categoryName: categoryName
      };
    });
  }

  return [];
}
//# sourceMappingURL=parser.js.map