"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VCheckbox/VCheckbox.sass");

require("../../../src/styles/components/_selection-controls.sass");

var _VIcon = _interopRequireDefault(require("../VIcon"));

var _VInput = _interopRequireDefault(require("../VInput"));

var _selectable = _interopRequireDefault(require("../../mixins/selectable"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* @vue/component */
var _default = _selectable.default.extend({
  name: 'v-checkbox',
  props: {
    indeterminate: Boolean,
    indeterminateIcon: {
      type: String,
      default: '$checkboxIndeterminate'
    },
    offIcon: {
      type: String,
      default: '$checkboxOff'
    },
    onIcon: {
      type: String,
      default: '$checkboxOn'
    }
  },
  data: function data() {
    return {
      inputIndeterminate: this.indeterminate
    };
  },
  computed: {
    classes: function classes() {
      return _objectSpread({}, _VInput.default.options.computed.classes.call(this), {
        'v-input--selection-controls': true,
        'v-input--checkbox': true,
        'v-input--indeterminate': this.inputIndeterminate
      });
    },
    computedIcon: function computedIcon() {
      if (this.inputIndeterminate) {
        return this.indeterminateIcon;
      } else if (this.isActive) {
        return this.onIcon;
      } else {
        return this.offIcon;
      }
    },
    // Do not return undefined if disabled,
    // according to spec, should still show
    // a color when disabled and active
    validationState: function validationState() {
      if (this.isDisabled && !this.inputIndeterminate) return undefined;
      if (this.hasError && this.shouldValidate) return 'error';
      if (this.hasSuccess) return 'success';
      if (this.hasColor !== null) return this.computedColor;
      return undefined;
    }
  },
  watch: {
    indeterminate: function indeterminate(val) {
      var _this = this;

      // https://github.com/vuetifyjs/vuetify/issues/8270
      this.$nextTick(function () {
        return _this.inputIndeterminate = val;
      });
    },
    inputIndeterminate: function inputIndeterminate(val) {
      this.$emit('update:indeterminate', val);
    },
    isActive: function isActive() {
      if (!this.indeterminate) return;
      this.inputIndeterminate = false;
    }
  },
  methods: {
    genCheckbox: function genCheckbox() {
      return this.$createElement('div', {
        staticClass: 'v-input--selection-controls__input'
      }, [this.$createElement(_VIcon.default, this.setTextColor(this.validationState, {
        props: {
          dense: this.dense,
          dark: this.dark,
          light: this.light
        }
      }), this.computedIcon), this.genInput('checkbox', _objectSpread({}, this.attrs$, {
        'aria-checked': this.inputIndeterminate ? 'mixed' : this.isActive.toString()
      })), this.genRipple(this.setTextColor(this.rippleState))]);
    },
    genDefaultSlot: function genDefaultSlot() {
      return [this.genCheckbox(), this.genLabel()];
    }
  }
});

exports.default = _default;
//# sourceMappingURL=VCheckbox.js.map