"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VGrid/VGrid.sass");

var _vue = _interopRequireDefault(require("vue"));

var _mergeData = _interopRequireDefault(require("../../util/mergeData"));

var _helpers = require("../../util/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// no xs
var breakpoints = ['sm', 'md', 'lg', 'xl'];
var ALIGNMENT = ['start', 'end', 'center'];

function makeProps(prefix, def) {
  return breakpoints.reduce(function (props, val) {
    props[prefix + (0, _helpers.upperFirst)(val)] = def();
    return props;
  }, {});
}

var alignValidator = function alignValidator(str) {
  return [].concat(ALIGNMENT, ['baseline', 'stretch']).includes(str);
};

var alignProps = makeProps('align', function () {
  return {
    type: String,
    default: null,
    validator: alignValidator
  };
});

var justifyValidator = function justifyValidator(str) {
  return [].concat(ALIGNMENT, ['space-between', 'space-around']).includes(str);
};

var justifyProps = makeProps('justify', function () {
  return {
    type: String,
    default: null,
    validator: justifyValidator
  };
});

var alignContentValidator = function alignContentValidator(str) {
  return [].concat(ALIGNMENT, ['space-between', 'space-around', 'stretch']).includes(str);
};

var alignContentProps = makeProps('alignContent', function () {
  return {
    type: String,
    default: null,
    validator: alignContentValidator
  };
});
var propMap = {
  align: Object.keys(alignProps),
  justify: Object.keys(justifyProps),
  alignContent: Object.keys(alignContentProps)
};
var classMap = {
  align: 'align',
  justify: 'justify',
  alignContent: 'align-content'
};

function breakpointClass(type, prop, val) {
  var className = classMap[type];

  if (val == null) {
    return undefined;
  }

  if (prop) {
    // alignSm -> Sm
    var breakpoint = prop.replace(type, '');
    className += "-".concat(breakpoint);
  } // .align-items-sm-center


  className += "-".concat(val);
  return className.toLowerCase();
}

var cache = new Map();

var _default = _vue.default.extend({
  name: 'v-row',
  functional: true,
  props: _objectSpread({
    tag: {
      type: String,
      default: 'div'
    },
    dense: Boolean,
    noGutters: Boolean,
    align: {
      type: String,
      default: null,
      validator: alignValidator
    }
  }, alignProps, {
    justify: {
      type: String,
      default: null,
      validator: justifyValidator
    }
  }, justifyProps, {
    alignContent: {
      type: String,
      default: null,
      validator: alignContentValidator
    }
  }, alignContentProps),
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    // Super-fast memoization based on props, 5x faster than JSON.stringify
    var cacheKey = '';

    for (var prop in props) {
      cacheKey += String(props[prop]);
    }

    var classList = cache.get(cacheKey);

    if (!classList) {
      (function () {
        var _classList$push;

        classList = []; // Loop through `align`, `justify`, `alignContent` breakpoint props

        var type;

        for (type in propMap) {
          propMap[type].forEach(function (prop) {
            var value = props[prop];
            var className = breakpointClass(type, prop, value);
            if (className) classList.push(className);
          });
        }

        classList.push((_classList$push = {
          'no-gutters': props.noGutters,
          'row--dense': props.dense
        }, _defineProperty(_classList$push, "align-".concat(props.align), props.align), _defineProperty(_classList$push, "justify-".concat(props.justify), props.justify), _defineProperty(_classList$push, "align-content-".concat(props.alignContent), props.alignContent), _classList$push));
        cache.set(cacheKey, classList);
      })();
    }

    return h(props.tag, (0, _mergeData.default)(data, {
      staticClass: 'row',
      class: classList
    }), children);
  }
});

exports.default = _default;
//# sourceMappingURL=VRow.js.map