"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VIcon/VIcon.sass");

var _bindsAttrs = _interopRequireDefault(require("../../mixins/binds-attrs"));

var _colorable = _interopRequireDefault(require("../../mixins/colorable"));

var _sizeable = _interopRequireDefault(require("../../mixins/sizeable"));

var _themeable = _interopRequireDefault(require("../../mixins/themeable"));

var _helpers = require("../../util/helpers");

var _vue = _interopRequireDefault(require("vue"));

var _mixins = _interopRequireDefault(require("../../util/mixins"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var SIZE_MAP;

(function (SIZE_MAP) {
  SIZE_MAP["xSmall"] = "12px";
  SIZE_MAP["small"] = "16px";
  SIZE_MAP["default"] = "24px";
  SIZE_MAP["medium"] = "28px";
  SIZE_MAP["large"] = "36px";
  SIZE_MAP["xLarge"] = "40px";
})(SIZE_MAP || (SIZE_MAP = {}));

function isFontAwesome5(iconType) {
  return ['fas', 'far', 'fal', 'fab', 'fad'].some(function (val) {
    return iconType.includes(val);
  });
}

function isSvgPath(icon) {
  return /^[mzlhvcsqta]\s*[-+.0-9][^mlhvzcsqta]+/i.test(icon) && /[\dz]$/i.test(icon) && icon.length > 4;
}

var VIcon = (0, _mixins.default)(_bindsAttrs.default, _colorable.default, _sizeable.default, _themeable.default
/* @vue/component */
).extend({
  name: 'v-icon',
  props: {
    dense: Boolean,
    disabled: Boolean,
    left: Boolean,
    right: Boolean,
    size: [Number, String],
    tag: {
      type: String,
      required: false,
      default: 'i'
    }
  },
  computed: {
    medium: function medium() {
      return false;
    },
    hasClickListener: function hasClickListener() {
      return Boolean(this.listeners$.click || this.listeners$['!click']);
    }
  },
  methods: {
    getIcon: function getIcon() {
      var iconName = '';
      if (this.$slots.default) iconName = this.$slots.default[0].text.trim();
      return (0, _helpers.remapInternalIcon)(this, iconName);
    },
    getSize: function getSize() {
      var sizes = {
        xSmall: this.xSmall,
        small: this.small,
        medium: this.medium,
        large: this.large,
        xLarge: this.xLarge
      };
      var explicitSize = (0, _helpers.keys)(sizes).find(function (key) {
        return sizes[key];
      });
      return explicitSize && SIZE_MAP[explicitSize] || (0, _helpers.convertToUnit)(this.size);
    },
    // Component data for both font icon and SVG wrapper span
    getDefaultData: function getDefaultData() {
      return {
        staticClass: 'v-icon notranslate',
        class: {
          'v-icon--disabled': this.disabled,
          'v-icon--left': this.left,
          'v-icon--link': this.hasClickListener,
          'v-icon--right': this.right,
          'v-icon--dense': this.dense
        },
        attrs: _objectSpread({
          'aria-hidden': !this.hasClickListener,
          disabled: this.hasClickListener && this.disabled,
          type: this.hasClickListener ? 'button' : undefined
        }, this.attrs$),
        on: this.listeners$
      };
    },
    getSvgWrapperData: function getSvgWrapperData() {
      var fontSize = this.getSize();

      var wrapperData = _objectSpread({}, this.getDefaultData(), {
        style: fontSize ? {
          fontSize: fontSize,
          height: fontSize,
          width: fontSize
        } : undefined
      });

      this.applyColors(wrapperData);
      return wrapperData;
    },
    applyColors: function applyColors(data) {
      data.class = _objectSpread({}, data.class, {}, this.themeClasses);
      this.setTextColor(this.color, data);
    },
    renderFontIcon: function renderFontIcon(icon, h) {
      var newChildren = [];
      var data = this.getDefaultData();
      var iconType = 'material-icons'; // Material Icon delimiter is _
      // https://material.io/icons/

      var delimiterIndex = icon.indexOf('-');
      var isMaterialIcon = delimiterIndex <= -1;

      if (isMaterialIcon) {
        // Material icon uses ligatures.
        newChildren.push(icon);
      } else {
        iconType = icon.slice(0, delimiterIndex);
        if (isFontAwesome5(iconType)) iconType = '';
      }

      data.class[iconType] = true;
      data.class[icon] = !isMaterialIcon;
      var fontSize = this.getSize();
      if (fontSize) data.style = {
        fontSize: fontSize
      };
      this.applyColors(data);
      return h(this.hasClickListener ? 'button' : this.tag, data, newChildren);
    },
    renderSvgIcon: function renderSvgIcon(icon, h) {
      var svgData = {
        class: 'v-icon__svg',
        attrs: {
          xmlns: 'http://www.w3.org/2000/svg',
          viewBox: '0 0 24 24',
          role: 'img',
          'aria-hidden': true
        }
      };
      var size = this.getSize();

      if (size) {
        svgData.style = {
          fontSize: size,
          height: size,
          width: size
        };
      }

      return h(this.hasClickListener ? 'button' : 'span', this.getSvgWrapperData(), [h('svg', svgData, [h('path', {
        attrs: {
          d: icon
        }
      })])]);
    },
    renderSvgIconComponent: function renderSvgIconComponent(icon, h) {
      var data = {
        class: {
          'v-icon__component': true
        }
      };
      var size = this.getSize();

      if (size) {
        data.style = {
          fontSize: size,
          height: size,
          width: size
        };
      }

      this.applyColors(data);
      var component = icon.component;
      data.props = icon.props;
      data.nativeOn = data.on;
      return h(this.hasClickListener ? 'button' : 'span', this.getSvgWrapperData(), [h(component, data)]);
    }
  },
  render: function render(h) {
    var icon = this.getIcon();

    if (typeof icon === 'string') {
      if (isSvgPath(icon)) {
        return this.renderSvgIcon(icon, h);
      }

      return this.renderFontIcon(icon, h);
    }

    return this.renderSvgIconComponent(icon, h);
  }
});

var _default = _vue.default.extend({
  name: 'v-icon',
  $_wrapperFor: VIcon,
  functional: true,
  render: function render(h, _ref) {
    var data = _ref.data,
        children = _ref.children;
    var iconName = ''; // Support usage of v-text and v-html

    if (data.domProps) {
      iconName = data.domProps.textContent || data.domProps.innerHTML || iconName; // Remove nodes so it doesn't
      // overwrite our changes

      delete data.domProps.textContent;
      delete data.domProps.innerHTML;
    }

    return h(VIcon, data, iconName ? [iconName] : children);
  }
});

exports.default = _default;
//# sourceMappingURL=VIcon.js.map