"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("../../../src/components/VList/VListGroup.sass");

var _VIcon = _interopRequireDefault(require("../VIcon"));

var _VListItem = _interopRequireDefault(require("./VListItem"));

var _VListItemIcon = _interopRequireDefault(require("./VListItemIcon"));

var _bindsAttrs = _interopRequireDefault(require("../../mixins/binds-attrs"));

var _bootable = _interopRequireDefault(require("../../mixins/bootable"));

var _colorable = _interopRequireDefault(require("../../mixins/colorable"));

var _toggleable = _interopRequireDefault(require("../../mixins/toggleable"));

var _registrable = require("../../mixins/registrable");

var _ripple = _interopRequireDefault(require("../../directives/ripple"));

var _transitions = require("../transitions");

var _mixins = _interopRequireDefault(require("../../util/mixins"));

var _helpers = require("../../util/helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var baseMixins = (0, _mixins.default)(_bindsAttrs.default, _bootable.default, _colorable.default, (0, _registrable.inject)('list'), _toggleable.default);

var _default = baseMixins.extend().extend({
  name: 'v-list-group',
  directives: {
    ripple: _ripple.default
  },
  props: {
    activeClass: {
      type: String,
      default: ''
    },
    appendIcon: {
      type: String,
      default: '$expand'
    },
    color: {
      type: String,
      default: 'primary'
    },
    disabled: Boolean,
    group: String,
    noAction: Boolean,
    prependIcon: String,
    ripple: {
      type: [Boolean, Object],
      default: true
    },
    subGroup: Boolean
  },
  computed: {
    classes: function classes() {
      return {
        'v-list-group--active': this.isActive,
        'v-list-group--disabled': this.disabled,
        'v-list-group--no-action': this.noAction,
        'v-list-group--sub-group': this.subGroup
      };
    }
  },
  watch: {
    isActive: function isActive(val) {
      /* istanbul ignore else */
      if (!this.subGroup && val) {
        this.list && this.list.listClick(this._uid);
      }
    },
    $route: 'onRouteChange'
  },
  created: function created() {
    this.list && this.list.register(this);

    if (this.group && this.$route && this.value == null) {
      this.isActive = this.matchRoute(this.$route.path);
    }
  },
  beforeDestroy: function beforeDestroy() {
    this.list && this.list.unregister(this);
  },
  methods: {
    click: function click(e) {
      var _this = this;

      if (this.disabled) return;
      this.isBooted = true;
      this.$emit('click', e);
      this.$nextTick(function () {
        return _this.isActive = !_this.isActive;
      });
    },
    genIcon: function genIcon(icon) {
      return this.$createElement(_VIcon.default, icon);
    },
    genAppendIcon: function genAppendIcon() {
      var icon = !this.subGroup ? this.appendIcon : false;
      if (!icon && !this.$slots.appendIcon) return null;
      return this.$createElement(_VListItemIcon.default, {
        staticClass: 'v-list-group__header__append-icon'
      }, [this.$slots.appendIcon || this.genIcon(icon)]);
    },
    genHeader: function genHeader() {
      return this.$createElement(_VListItem.default, {
        staticClass: 'v-list-group__header',
        attrs: {
          'aria-expanded': String(this.isActive),
          role: 'button'
        },
        class: _defineProperty({}, this.activeClass, this.isActive),
        props: {
          inputValue: this.isActive
        },
        directives: [{
          name: 'ripple',
          value: this.ripple
        }],
        on: _objectSpread({}, this.listeners$, {
          click: this.click
        })
      }, [this.genPrependIcon(), this.$slots.activator, this.genAppendIcon()]);
    },
    genItems: function genItems() {
      var _this2 = this;

      return this.showLazyContent(function () {
        return [_this2.$createElement('div', {
          staticClass: 'v-list-group__items',
          directives: [{
            name: 'show',
            value: _this2.isActive
          }]
        }, (0, _helpers.getSlot)(_this2))];
      });
    },
    genPrependIcon: function genPrependIcon() {
      var icon = this.subGroup && this.prependIcon == null ? '$subgroup' : this.prependIcon;
      if (!icon && !this.$slots.prependIcon) return null;
      return this.$createElement(_VListItemIcon.default, {
        staticClass: 'v-list-group__header__prepend-icon'
      }, [this.$slots.prependIcon || this.genIcon(icon)]);
    },
    onRouteChange: function onRouteChange(to) {
      /* istanbul ignore if */
      if (!this.group) return;
      var isActive = this.matchRoute(to.path);
      /* istanbul ignore else */

      if (isActive && this.isActive !== isActive) {
        this.list && this.list.listClick(this._uid);
      }

      this.isActive = isActive;
    },
    toggle: function toggle(uid) {
      var _this3 = this;

      var isActive = this._uid === uid;
      if (isActive) this.isBooted = true;
      this.$nextTick(function () {
        return _this3.isActive = isActive;
      });
    },
    matchRoute: function matchRoute(to) {
      return to.match(this.group) !== null;
    }
  },
  render: function render(h) {
    return h('div', this.setTextColor(this.isActive && this.color, {
      staticClass: 'v-list-group',
      class: this.classes
    }), [this.genHeader(), h(_transitions.VExpandTransition, this.genItems())]);
  }
});

exports.default = _default;
//# sourceMappingURL=VListGroup.js.map